/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.versioning.ImmutableModuleVersion;
import de.hilling.maven.release.versioning.ReleaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableReleaseInfo
extends ReleaseInfo {
    @Nullable
    private final String tagName;
    private final List<ImmutableModuleVersion> modules;

    private ImmutableReleaseInfo(@Nullable String tagName, List<ImmutableModuleVersion> modules) {
        this.tagName = tagName;
        this.modules = modules;
    }

    @Override
    public Optional<String> getTagName() {
        return Optional.ofNullable(this.tagName);
    }

    @Override
    public List<ImmutableModuleVersion> getModules() {
        return this.modules;
    }

    public final ImmutableReleaseInfo withTagName(String value) {
        String newValue = Objects.requireNonNull(value, "tagName");
        if (Objects.equals(this.tagName, newValue)) {
            return this;
        }
        return new ImmutableReleaseInfo(newValue, this.modules);
    }

    public final ImmutableReleaseInfo withTagName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tagName, value)) {
            return this;
        }
        return new ImmutableReleaseInfo(value, this.modules);
    }

    public final ImmutableReleaseInfo withModules(ImmutableModuleVersion ... elements) {
        List<ImmutableModuleVersion> newValue = ImmutableReleaseInfo.createUnmodifiableList(false, ImmutableReleaseInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReleaseInfo(this.tagName, newValue);
    }

    public final ImmutableReleaseInfo withModules(Iterable<? extends ImmutableModuleVersion> elements) {
        if (this.modules == elements) {
            return this;
        }
        List<ImmutableModuleVersion> newValue = ImmutableReleaseInfo.createUnmodifiableList(false, ImmutableReleaseInfo.createSafeList(elements, true, false));
        return new ImmutableReleaseInfo(this.tagName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReleaseInfo && this.equalTo((ImmutableReleaseInfo)another);
    }

    private boolean equalTo(ImmutableReleaseInfo another) {
        return Objects.equals(this.tagName, another.tagName) && this.modules.equals(another.modules);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tagName);
        h += (h << 5) + this.modules.hashCode();
        return h;
    }

    public static ImmutableReleaseInfo copyOf(ReleaseInfo instance) {
        if (instance instanceof ImmutableReleaseInfo) {
            return (ImmutableReleaseInfo)instance;
        }
        return ImmutableReleaseInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String tagName;
        private List<ImmutableModuleVersion> modules = new ArrayList<ImmutableModuleVersion>();

        private Builder() {
        }

        public final Builder from(ReleaseInfo instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> tagNameOptional = instance.getTagName();
            if (tagNameOptional.isPresent()) {
                this.tagName(tagNameOptional);
            }
            this.addAllModules(instance.getModules());
            return this;
        }

        public final Builder tagName(String tagName) {
            this.tagName = Objects.requireNonNull(tagName, "tagName");
            return this;
        }

        public final Builder tagName(Optional<String> tagName) {
            this.tagName = tagName.orElse(null);
            return this;
        }

        public final Builder addModules(ImmutableModuleVersion element) {
            this.modules.add(Objects.requireNonNull(element, "modules element"));
            return this;
        }

        public final Builder addModules(ImmutableModuleVersion ... elements) {
            for (ImmutableModuleVersion element : elements) {
                this.modules.add(Objects.requireNonNull(element, "modules element"));
            }
            return this;
        }

        public final Builder modules(Iterable<? extends ImmutableModuleVersion> elements) {
            this.modules.clear();
            return this.addAllModules(elements);
        }

        public final Builder addAllModules(Iterable<? extends ImmutableModuleVersion> elements) {
            for (ImmutableModuleVersion immutableModuleVersion : elements) {
                this.modules.add(Objects.requireNonNull(immutableModuleVersion, "modules element"));
            }
            return this;
        }

        public ImmutableReleaseInfo build() {
            return new ImmutableReleaseInfo(this.tagName, ImmutableReleaseInfo.createUnmodifiableList(true, this.modules));
        }
    }
}

