/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.versioning.SnapshotVersion;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSnapshotVersion
implements SnapshotVersion {
    private final long majorVersion;

    private ImmutableSnapshotVersion(long majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    public long getMajorVersion() {
        return this.majorVersion;
    }

    public final ImmutableSnapshotVersion withMajorVersion(long value) {
        if (this.majorVersion == value) {
            return this;
        }
        return new ImmutableSnapshotVersion(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSnapshotVersion && this.equalTo((ImmutableSnapshotVersion)another);
    }

    private boolean equalTo(ImmutableSnapshotVersion another) {
        return this.majorVersion == another.majorVersion;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.majorVersion);
        return h;
    }

    public String toString() {
        return "SnapshotVersion{majorVersion=" + this.majorVersion + "}";
    }

    public static ImmutableSnapshotVersion copyOf(SnapshotVersion instance) {
        if (instance instanceof ImmutableSnapshotVersion) {
            return (ImmutableSnapshotVersion)instance;
        }
        return ImmutableSnapshotVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAJOR_VERSION = 1L;
        private long initBits = 1L;
        private long majorVersion;

        private Builder() {
        }

        public final Builder from(SnapshotVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.majorVersion(instance.getMajorVersion());
            return this;
        }

        public final Builder majorVersion(long majorVersion) {
            this.majorVersion = majorVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSnapshotVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSnapshotVersion(this.majorVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("majorVersion");
            }
            return "Cannot build SnapshotVersion, some of required attributes are not set " + attributes;
        }
    }
}

