/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ObjectBuffer;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.BigDecimalSerializer;
import com.esotericsoftware.kryo.serialize.BigIntegerSerializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.ClassSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyListSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptyMapSerializer;
import de.javakaffee.kryoserializers.CollectionsEmptySetSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonListSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonMapSerializer;
import de.javakaffee.kryoserializers.CollectionsSingletonSetSerializer;
import de.javakaffee.kryoserializers.CopyForIterateCollectionSerializer;
import de.javakaffee.kryoserializers.CopyForIterateMapSerializer;
import de.javakaffee.kryoserializers.CurrencySerializer;
import de.javakaffee.kryoserializers.EnumMapSerializer;
import de.javakaffee.kryoserializers.EnumSetSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.KryoReflectionFactorySupport;
import de.javakaffee.kryoserializers.StringBufferSerializer;
import de.javakaffee.kryoserializers.StringBuilderSerializer;
import de.javakaffee.kryoserializers.SubListSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.SessionTranscoder;
import de.javakaffee.web.msm.serializer.kryo.KryoCustomization;
import de.javakaffee.web.msm.serializer.kryo.SerializerFactory;
import de.javakaffee.web.msm.serializer.kryo.UnregisteredClassHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class KryoTranscoder
extends SessionTranscoder
implements SessionAttributesTranscoder {
    private static final Log LOG = LogFactory.getLog(KryoTranscoder.class);
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 102400;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 2048000;
    private final Kryo _kryo;
    private final SerializerFactory[] _serializerFactories;
    private final UnregisteredClassHandler[] _unregisteredClassHandlers;
    private final int _initialBufferSize;
    private final int _maxBufferSize;

    public KryoTranscoder() {
        this(null, null, false);
    }

    public KryoTranscoder(ClassLoader classLoader, String[] customConverterClassNames, boolean copyCollectionsForSerialization) {
        this(classLoader, customConverterClassNames, copyCollectionsForSerialization, 102400, 2048000);
    }

    public KryoTranscoder(ClassLoader classLoader, String[] customConverterClassNames, boolean copyCollectionsForSerialization, int initialBufferSize, int maxBufferSize) {
        LOG.info((Object)("Starting with initialBufferSize " + initialBufferSize + " and maxBufferSize " + maxBufferSize));
        Triple<Kryo, SerializerFactory[], UnregisteredClassHandler[]> triple = this.createKryo(classLoader, customConverterClassNames, copyCollectionsForSerialization);
        this._kryo = (Kryo)((Triple)triple).a;
        this._serializerFactories = (SerializerFactory[])((Triple)triple).b;
        this._unregisteredClassHandlers = (UnregisteredClassHandler[])((Triple)triple).c;
        this._initialBufferSize = initialBufferSize;
        this._maxBufferSize = maxBufferSize;
    }

    private Triple<Kryo, SerializerFactory[], UnregisteredClassHandler[]> createKryo(ClassLoader classLoader, String[] customConverterClassNames, final boolean copyCollectionsForSerialization) {
        KryoReflectionFactorySupport kryo = new KryoReflectionFactorySupport(){

            public Serializer newSerializer(Class clazz) {
                Serializer copyCollectionSerializer;
                Serializer customSerializer = KryoTranscoder.this.loadCustomSerializer(clazz);
                if (customSerializer != null) {
                    return customSerializer;
                }
                if (EnumSet.class.isAssignableFrom(clazz)) {
                    return new EnumSetSerializer((Kryo)this);
                }
                if (EnumMap.class.isAssignableFrom(clazz)) {
                    return new EnumMapSerializer((Kryo)this);
                }
                if (SubListSerializer.canSerialize((Class)clazz)) {
                    return new SubListSerializer((Kryo)this);
                }
                if (copyCollectionsForSerialization && (copyCollectionSerializer = KryoTranscoder.this.loadCopyCollectionSerializer(clazz, (Kryo)this)) != null) {
                    return copyCollectionSerializer;
                }
                return super.newSerializer(clazz);
            }

            protected void handleUnregisteredClass(Class clazz) {
                if (KryoTranscoder.this._unregisteredClassHandlers != null) {
                    for (int i = 0; i < KryoTranscoder.this._unregisteredClassHandlers.length; ++i) {
                        boolean handled = KryoTranscoder.this._unregisteredClassHandlers[i].handleUnregisteredClass(clazz);
                        if (!handled) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("UnregisteredClassHandler " + KryoTranscoder.this._unregisteredClassHandlers[i].getClass().getName() + " handled class " + clazz));
                        }
                        return;
                    }
                }
                super.handleUnregisteredClass(clazz);
            }
        };
        if (classLoader != null) {
            kryo.setClassLoader(classLoader);
        }
        kryo.setRegistrationOptional(true);
        kryo.register(ArrayList.class);
        kryo.register(LinkedList.class);
        kryo.register(HashSet.class);
        kryo.register(HashMap.class);
        kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer((Kryo)kryo));
        kryo.register(Currency.class, (Serializer)new CurrencySerializer((Kryo)kryo));
        kryo.register(StringBuffer.class, (Serializer)new StringBufferSerializer((Kryo)kryo));
        kryo.register(StringBuilder.class, (Serializer)new StringBuilderSerializer((Kryo)kryo));
        kryo.register(Collections.EMPTY_LIST.getClass(), (Serializer)new CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), (Serializer)new CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), (Serializer)new CollectionsEmptySetSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new CollectionsSingletonListSerializer((Kryo)kryo));
        kryo.register(Collections.singleton("").getClass(), (Serializer)new CollectionsSingletonSetSerializer((Kryo)kryo));
        kryo.register(Collections.singletonMap("", "").getClass(), (Serializer)new CollectionsSingletonMapSerializer((Kryo)kryo));
        kryo.register(Class.class, (Serializer)new ClassSerializer((Kryo)kryo));
        kryo.register(BigDecimal.class, (Serializer)new BigDecimalSerializer());
        kryo.register(BigInteger.class, (Serializer)new BigIntegerSerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer((Kryo)kryo));
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        Triple<KryoCustomization[], SerializerFactory[], UnregisteredClassHandler[]> pair = this.loadCustomConverter(customConverterClassNames, classLoader, (Kryo)kryo);
        KryoCustomization[] customizations = (KryoCustomization[])((Triple)pair).a;
        if (customizations != null) {
            for (KryoCustomization customization : customizations) {
                try {
                    LOG.info((Object)("Executing KryoCustomization " + customization.getClass().getName()));
                    customization.customize((Kryo)kryo);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Could not execute customization " + customization), e);
                }
            }
        }
        return Triple.create(kryo, ((Triple)pair).b, ((Triple)pair).c);
    }

    private Serializer loadCustomSerializer(Class<?> clazz) {
        if (this._serializerFactories != null) {
            for (int i = 0; i < this._serializerFactories.length; ++i) {
                Serializer serializer = this._serializerFactories[i].newSerializer(clazz);
                if (serializer == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loading custom serializer " + serializer.getClass().getName() + " for class " + clazz));
                }
                return serializer;
            }
        }
        return null;
    }

    private Serializer loadCopyCollectionSerializer(Class<?> clazz, Kryo kryo) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading CopyForIterateCollectionSerializer for class " + clazz));
            }
            return new CopyForIterateCollectionSerializer(kryo);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading CopyForIterateMapSerializer for class " + clazz));
            }
            return new CopyForIterateMapSerializer(kryo);
        }
        return null;
    }

    public Map<String, Object> deserializeAttributes(byte[] data) {
        return (Map)new ObjectBuffer(this._kryo).readObject(data, ConcurrentHashMap.class);
    }

    public byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        return new ObjectBuffer(this._kryo, this._initialBufferSize, this._maxBufferSize).writeObject(attributes);
    }

    protected MemcachedBackupSession deserialize(byte[] in) {
        throw new UnsupportedOperationException("Session deserialization not implemented.");
    }

    private Triple<KryoCustomization[], SerializerFactory[], UnregisteredClassHandler[]> loadCustomConverter(String[] customConverterClassNames, ClassLoader classLoader, Kryo kryo) {
        if (customConverterClassNames == null || customConverterClassNames.length == 0) {
            return Triple.empty();
        }
        ArrayList<KryoCustomization> customizations = new ArrayList<KryoCustomization>();
        ArrayList<SerializerFactory> serializerFactories = new ArrayList<SerializerFactory>();
        ArrayList<UnregisteredClassHandler> unregisteredClassHandlers = new ArrayList<UnregisteredClassHandler>();
        ClassLoader loader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < customConverterClassNames.length; ++i) {
            String element = customConverterClassNames[i];
            try {
                this.processElement(element, customizations, serializerFactories, unregisteredClassHandlers, kryo, loader);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)("Could not instantiate " + element + ", omitting this KryoCustomization/SerializerFactory."), (Throwable)e);
                throw new RuntimeException("Could not load serializer " + element, e);
            }
        }
        KryoCustomization[] customizationsArray = customizations.toArray(new KryoCustomization[customizations.size()]);
        SerializerFactory[] serializerFactoriesArray = serializerFactories.toArray(new SerializerFactory[serializerFactories.size()]);
        UnregisteredClassHandler[] unregisteredClassHandlersArray = unregisteredClassHandlers.toArray(new UnregisteredClassHandler[unregisteredClassHandlers.size()]);
        return Triple.create(customizationsArray, serializerFactoriesArray, unregisteredClassHandlersArray);
    }

    private void processElement(String element, List<KryoCustomization> customizations, List<SerializerFactory> serializerFactories, List<UnregisteredClassHandler> unregisteredClassHandlers, Kryo kryo, ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(element, true, loader);
        if (KryoCustomization.class.isAssignableFrom(clazz)) {
            LOG.info((Object)("Loading KryoCustomization " + element));
            KryoCustomization customization = KryoTranscoder.createInstance(clazz.asSubclass(KryoCustomization.class), kryo);
            customizations.add(customization);
            if (customization instanceof SerializerFactory) {
                serializerFactories.add((SerializerFactory)((Object)customization));
            }
        }
        if (SerializerFactory.class.isAssignableFrom(clazz)) {
            LOG.info((Object)("Loading SerializerFactory " + element));
            SerializerFactory factory = KryoTranscoder.createInstance(clazz.asSubclass(SerializerFactory.class), kryo);
            serializerFactories.add(factory);
        }
        if (UnregisteredClassHandler.class.isAssignableFrom(clazz)) {
            LOG.info((Object)("Loading UnregisteredClassHandler " + element));
            UnregisteredClassHandler handler = KryoTranscoder.createInstance(clazz.asSubclass(UnregisteredClassHandler.class), kryo);
            unregisteredClassHandlers.add(handler);
        }
    }

    private static <T> T createInstance(Class<? extends T> clazz, Kryo kryo) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Constructor<T> constructor = clazz.getConstructor(Kryo.class);
            return constructor.newInstance(kryo);
        }
        catch (NoSuchMethodException nsme) {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
    }

    private static class Triple<A, B, C> {
        private static final Triple<?, ?, ?> EMPTY = Triple.create(null, null, null);
        private final A a;
        private final B b;
        private final C c;

        public Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public static <A, B, C> Triple<A, B, C> create(A a, B b, C c) {
            return new Triple<A, B, C>(a, b, c);
        }

        public static <A, B, C> Triple<A, B, C> empty() {
            return EMPTY;
        }
    }
}

