/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Comparators {
    public static <T> Comparator<T> chain(final Comparator<T> c1, final Comparator<T> c2) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = c1.compare(o1, o2);
                return x == 0 ? c2.compare(o1, o2) : x;
            }
        };
    }

    public static <T> Comparator<T> chain(final List<Comparator<T>> c) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = 0;
                Iterator it = c.iterator();
                while (x == 0 && it.hasNext()) {
                    x = ((Comparator)it.next()).compare(o1, o2);
                }
                return x;
            }
        };
    }

    public static <T> Comparator<T> chain(Comparator<T> ... c) {
        return Comparators.chain(Arrays.asList(c));
    }

    public static <T extends Comparable<? super T>> int nullSafeComparator(T one, T two) {
        if (one == null ^ two == null) {
            return one == null ? -1 : 1;
        }
        if (one == null && two == null) {
            return 0;
        }
        return one.compareTo(two);
    }
}

