/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.KBestViterbiParser;
import edu.stanford.nlp.parser.lexparser.NoSuchParseException;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParserConstraint;
import edu.stanford.nlp.parser.lexparser.ParserQuery;
import edu.stanford.nlp.parser.lexparser.Reranker;
import edu.stanford.nlp.parser.lexparser.RerankerQuery;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ScoredComparator;
import edu.stanford.nlp.util.ScoredObject;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RerankingParserQuery
implements ParserQuery {
    private final Options op;
    private final ParserQuery parserQuery;
    private final Reranker reranker;
    private final int rerankerKBest;
    private List<ScoredObject<Tree>> scoredTrees;

    public RerankingParserQuery(Options op, ParserQuery parserQuery, Reranker reranker) {
        this.op = op;
        this.parserQuery = parserQuery;
        this.reranker = reranker;
        this.rerankerKBest = op.rerankerKBest;
    }

    @Override
    public boolean saidMemMessage() {
        return this.parserQuery.saidMemMessage();
    }

    @Override
    public void setConstraints(List<ParserConstraint> constraints) {
        this.parserQuery.setConstraints(constraints);
    }

    @Override
    public boolean parse(List<? extends HasWord> sentence) {
        boolean success = this.parserQuery.parse(sentence);
        if (!success) {
            return false;
        }
        List<ScoredObject<Tree>> bestKParses = this.parserQuery.getKBestPCFGParses(this.rerankerKBest);
        if (bestKParses.size() == 0) {
            return false;
        }
        this.scoredTrees = this.rerank(sentence, bestKParses);
        return true;
    }

    @Override
    public boolean parseAndReport(List<? extends HasWord> sentence, PrintWriter pwErr) {
        boolean success = this.parserQuery.parseAndReport(sentence, pwErr);
        if (!success) {
            return false;
        }
        List<ScoredObject<Tree>> bestKParses = this.parserQuery.getKBestPCFGParses(this.rerankerKBest);
        if (bestKParses.size() == 0) {
            return false;
        }
        this.scoredTrees = this.rerank(sentence, bestKParses);
        return true;
    }

    List<ScoredObject<Tree>> rerank(List<? extends HasWord> sentence, List<ScoredObject<Tree>> bestKParses) {
        RerankerQuery rq = this.reranker.process(sentence);
        ArrayList<ScoredObject<Tree>> reranked = new ArrayList<ScoredObject<Tree>>();
        for (ScoredObject<Tree> scoredTree : bestKParses) {
            double score = scoredTree.score();
            try {
                score = this.op.baseParserWeight * score + rq.score(scoredTree.object());
            }
            catch (NoSuchParseException e) {
                score = Double.NEGATIVE_INFINITY;
            }
            reranked.add(new ScoredObject<Tree>(scoredTree.object(), score));
        }
        Collections.sort(reranked, ScoredComparator.DESCENDING_COMPARATOR);
        return reranked;
    }

    @Override
    public Tree getBestParse() {
        if (this.scoredTrees == null || this.scoredTrees.size() == 0) {
            return null;
        }
        return this.scoredTrees.get(0).object();
    }

    @Override
    public Tree getBestPCFGParse() {
        return this.getBestParse();
    }

    @Override
    public double getPCFGScore() {
        if (this.scoredTrees == null || this.scoredTrees.size() == 0) {
            throw new AssertionError();
        }
        return this.scoredTrees.get(0).score();
    }

    @Override
    public Tree getBestDependencyParse(boolean debinarize) {
        return null;
    }

    @Override
    public Tree getBestFactoredParse() {
        return null;
    }

    @Override
    public List<ScoredObject<Tree>> getBestPCFGParses() {
        if (this.scoredTrees == null || this.scoredTrees.size() == 0) {
            throw new AssertionError();
        }
        ArrayList<ScoredObject<Tree>> equalTrees = Generics.newArrayList();
        double score = this.scoredTrees.get(0).score();
        int treePos = 0;
        while (treePos < this.scoredTrees.size() && this.scoredTrees.get(treePos).score() == score) {
            equalTrees.add(this.scoredTrees.get(treePos));
        }
        return equalTrees;
    }

    @Override
    public void restoreOriginalWords(Tree tree) {
        this.parserQuery.restoreOriginalWords(tree);
    }

    @Override
    public boolean hasFactoredParse() {
        return false;
    }

    @Override
    public List<ScoredObject<Tree>> getKBestPCFGParses(int kbestPCFG) {
        ArrayList<ScoredObject<Tree>> trees = Generics.newArrayList();
        for (int treePos = 0; treePos < this.scoredTrees.size() && treePos < kbestPCFG; ++treePos) {
            trees.add(this.scoredTrees.get(treePos));
        }
        return trees;
    }

    @Override
    public List<ScoredObject<Tree>> getKGoodFactoredParses(int kbest) {
        return null;
    }

    @Override
    public KBestViterbiParser getPCFGParser() {
        return null;
    }

    @Override
    public KBestViterbiParser getFactoredParser() {
        return null;
    }

    @Override
    public KBestViterbiParser getDependencyParser() {
        return null;
    }

    @Override
    public boolean parseSucceeded() {
        return this.parserQuery.parseSucceeded();
    }

    @Override
    public boolean parseSkipped() {
        return this.parserQuery.parseSkipped();
    }

    @Override
    public boolean parseFallback() {
        return this.parserQuery.parseFallback();
    }

    @Override
    public boolean parseNoMemory() {
        return this.parserQuery.parseNoMemory();
    }

    @Override
    public boolean parseUnparsable() {
        return this.parserQuery.parseUnparsable();
    }

    @Override
    public List<? extends HasWord> originalSentence() {
        return this.parserQuery.originalSentence();
    }
}

