/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyPrinter;
import edu.stanford.nlp.trees.DependencyReader;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.NamedDependency;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.SimpleTree;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraph;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;

public abstract class GrammaticalStructure
extends TreeGraph {
    private static final boolean PRINT_DEBUGGING = false;
    protected final Set<Dependency<Label, Label, Object>> dependencies;
    protected final List<TypedDependency> typedDependencies;
    protected final List<TypedDependency> allTypedDependencies;
    protected final Filter<String> puncFilter;
    private static final long serialVersionUID = 2286294455343892678L;
    public static final String DEFAULT_PARSER_FILE = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    public static final int CoNLLX_WordField = 1;
    public static final int CoNLLX_POSField = 3;
    public static final int CoNLLX_GovField = 6;
    public static final int CoNLLX_RelnField = 7;
    public static final int CoNLLX_FieldCount = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, Lock relationsLock, HeadFinder hf, Filter<String> puncFilter) {
        super(t);
        this.root.percolateHeads(hf);
        this.puncFilter = puncFilter;
        NoPunctFilter puncDepFilter = new NoPunctFilter(puncFilter);
        NoPunctTypedDependencyFilter puncTypedDepFilter = new NoPunctTypedDependencyFilter(puncFilter);
        this.dependencies = this.root.dependencies(puncDepFilter, null);
        for (Dependency<Label, Label, Object> p : this.dependencies) {
            TreeGraphNode gov = (TreeGraphNode)p.governor();
            TreeGraphNode dep = (TreeGraphNode)p.dependent();
            dep.addArc(GrammaticalRelation.getAnnotationClass(GrammaticalRelation.GOVERNOR), gov);
        }
        if (relationsLock != null) {
            relationsLock.lock();
        }
        try {
            GrammaticalStructure.analyzeNode(this.root, this.root, relations);
        }
        finally {
            if (relationsLock != null) {
                relationsLock.unlock();
            }
        }
        this.typedDependencies = this.getDeps(false, puncTypedDepFilter);
        this.allTypedDependencies = this.getDeps(true, puncTypedDepFilter);
    }

    private static void throwDepFormatException(String dep) {
        throw new RuntimeException(String.format("Dependencies should be for the format 'type(arg-idx, arg-idx)'. Could not parse '%s'", dep));
    }

    public static GrammaticalStructure fromStringReps(List<String> tokens, List<String> posTags, List<String> deps) {
        if (tokens.size() != posTags.size()) {
            throw new RuntimeException(String.format("tokens.size(): %d != pos.size(): %d\n", tokens.size(), posTags.size()));
        }
        ArrayList<TreeGraphNode> tgWordNodes = new ArrayList<TreeGraphNode>(tokens.size());
        ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokens.size());
        SemanticHeadFinder headFinder = new SemanticHeadFinder();
        Iterator<String> posIter = posTags.iterator();
        for (String wordString : tokens) {
            String posString = posIter.next();
            TreeGraphNode word = new TreeGraphNode(new Word(wordString));
            TreeGraphNode pos = new TreeGraphNode(new Word(posString));
            tgWordNodes.add(word);
            tgPOSNodes.add(pos);
            Tree[] childArr = new TreeGraphNode[]{word};
            pos.setChildren(childArr);
            word.setParent(pos);
            pos.percolateHeads(headFinder);
        }
        TreeGraphNode root = new TreeGraphNode(new StringLabel("ROOT"));
        root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
        root.setIndex(0);
        ArrayList<TypedDependency> tdeps = new ArrayList<TypedDependency>(deps.size());
        for (String depString : deps) {
            int childDash;
            String args;
            int argSep;
            int firstBracket = depString.indexOf(40);
            if (firstBracket == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            String type = depString.substring(0, firstBracket);
            if (depString.charAt(depString.length() - 1) != ')') {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            if ((argSep = (args = depString.substring(firstBracket + 1, depString.length() - 1)).indexOf(", ")) == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            String parentArg = args.substring(0, argSep);
            String childArg = args.substring(argSep + 2);
            int parentDash = parentArg.lastIndexOf(45);
            if (parentDash == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            if ((childDash = childArg.lastIndexOf(45)) == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            int parentIdx = Integer.parseInt(parentArg.substring(parentDash + 1).replace("'", ""));
            int childIdx = Integer.parseInt(childArg.substring(childDash + 1).replace("'", ""));
            GrammaticalRelation grel = new GrammaticalRelation(GrammaticalRelation.Language.Any, type, null, null, GrammaticalRelation.DEPENDENT);
            TypedDependency tdep = new TypedDependency(grel, parentIdx == 0 ? root : (TreeGraphNode)tgWordNodes.get(parentIdx - 1), (TreeGraphNode)tgWordNodes.get(childIdx - 1));
            tdeps.add(tdep);
        }
        return new GrammaticalStructure(tdeps, root){
            private static final long serialVersionUID = 1L;
        };
    }

    public GrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(root);
        this.puncFilter = Filters.acceptFilter();
        this.typedDependencies = new ArrayList<TypedDependency>(projectiveDependencies);
        this.allTypedDependencies = this.typedDependencies;
        this.dependencies = Generics.newHashSet();
        for (TypedDependency tdep : projectiveDependencies) {
            this.dependencies.add(new NamedDependency(tdep.gov().toString(), tdep.dep().toString(), (Object)tdep.reln()));
        }
    }

    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, HeadFinder hf, Filter<String> puncFilter) {
        this(t, relations, null, hf, puncFilter);
    }

    private static void analyzeNode(TreeGraphNode t, TreeGraphNode root, Collection<GrammaticalRelation> relations) {
        if (t.isPhrasal()) {
            TreeGraphNode tHigh = t.highestNodeWithSameHead();
            for (GrammaticalRelation egr : relations) {
                if (!egr.isApplicable(t)) continue;
                for (Tree u : egr.getRelatedNodes(t, root)) {
                    tHigh.addArc(GrammaticalRelation.getAnnotationClass(egr), (TreeGraphNode)u);
                }
            }
            for (TreeGraphNode kid : t.children()) {
                GrammaticalStructure.analyzeNode(kid, root, relations);
            }
        }
    }

    private List<TypedDependency> getDeps(boolean getExtra, Filter<TypedDependency> f) {
        TypedDependency rootTypedDep;
        ArrayList<TypedDependency> basicDep = Generics.newArrayList();
        for (Dependency<Label, Label, Object> d : this.dependencies()) {
            TreeGraphNode gov = (TreeGraphNode)d.governor();
            TreeGraphNode dep = (TreeGraphNode)d.dependent();
            GrammaticalRelation reln = GrammaticalStructure.getGrammaticalRelation(gov, dep);
            basicDep.add(new TypedDependency(reln, gov, dep));
        }
        TreeGraphNode dependencyRoot = new TreeGraphNode(new Word("ROOT"));
        dependencyRoot.setIndex(0);
        TreeGraphNode rootDep = null;
        Collection<TypedDependency> roots = GrammaticalStructure.getRoots(basicDep);
        if (roots.size() == 0) {
            List<Tree> leaves = Trees.leaves(this.root());
            if (leaves.size() > 0) {
                Tree leaf = leaves.get(0);
                if (!(leaf instanceof TreeGraphNode)) {
                    throw new AssertionError((Object)"Leaves should be TreeGraphNodes");
                }
                rootDep = (TreeGraphNode)leaf;
                if (rootDep.headWordNode() != null) {
                    rootDep = rootDep.headWordNode();
                }
            }
        } else {
            Iterator<TypedDependency> iterator = roots.iterator();
            rootDep = iterator.next().gov();
        }
        if (rootDep != null && f.accept(rootTypedDep = new TypedDependency(GrammaticalRelation.ROOT, dependencyRoot, rootDep))) {
            basicDep.add(rootTypedDep);
        }
        if (getExtra) {
            this.getExtras(basicDep);
            GrammaticalStructure.getTreeDeps(this.root(), basicDep, f);
        }
        Collections.sort(basicDep);
        return basicDep;
    }

    protected void getExtras(List<TypedDependency> basicDep) {
    }

    private static void getTreeDeps(TreeGraphNode t, List<TypedDependency> basicDep, Filter<TypedDependency> f) {
        if (t.isPhrasal()) {
            Map<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>, Set<TreeGraphNode>> depMap = GrammaticalStructure.getAllDependents(t);
            for (Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> depName : depMap.keySet()) {
                for (TreeGraphNode depNode : depMap.get(depName)) {
                    List<GrammaticalRelation> rels;
                    TreeGraphNode dep;
                    TreeGraphNode gov = t.headWordNode();
                    if (gov == (dep = depNode.headWordNode()) || (rels = GrammaticalStructure.getListGrammaticalRelation(t, depNode)).isEmpty()) continue;
                    for (GrammaticalRelation rel : rels) {
                        TypedDependency newDep = new TypedDependency(rel, gov, dep);
                        if (basicDep.contains(newDep) || !f.accept(newDep)) continue;
                        newDep.setExtra();
                        basicDep.add(newDep);
                    }
                }
            }
            for (TreeGraphNode kid : t.children()) {
                GrammaticalStructure.getTreeDeps(kid, basicDep, f);
            }
        }
    }

    public Set<Dependency<Label, Label, Object>> dependencies() {
        return this.dependencies;
    }

    public static Set<TreeGraphNode> getDependents(TreeGraphNode t) {
        TreeSet<TreeGraphNode> deps = Generics.newTreeSet();
        for (Tree subtree : t) {
            TreeGraphNode node = (TreeGraphNode)subtree;
            TreeGraphNode gov = GrammaticalStructure.getGovernor(node);
            if (gov == null || gov != t) continue;
            deps.add(node);
        }
        return deps;
    }

    public static TreeGraphNode getGovernor(TreeGraphNode t) {
        return GrammaticalStructure.getNodeInRelation(t, GrammaticalRelation.GOVERNOR);
    }

    public static TreeGraphNode getNodeInRelation(TreeGraphNode t, GrammaticalRelation r) {
        return t.followArcToNode(GrammaticalRelation.getAnnotationClass(r));
    }

    public GrammaticalRelation getGrammaticalRelation(int govIndex, int depIndex) {
        TreeGraphNode gov = this.getNodeByIndex(govIndex);
        TreeGraphNode dep = this.getNodeByIndex(depIndex);
        return GrammaticalStructure.getGrammaticalRelation(gov, dep);
    }

    public static GrammaticalRelation getGrammaticalRelation(TreeGraphNode gov, TreeGraphNode dep) {
        GrammaticalRelation reln = GrammaticalRelation.DEPENDENT;
        TreeGraphNode govH = gov.highestNodeWithSameHead();
        TreeGraphNode depH = dep.highestNodeWithSameHead();
        TreeSet arcLabels = new TreeSet(new NameComparator());
        arcLabels.addAll(govH.arcLabelsToNode(depH));
        for (Class arcLabel : arcLabels) {
            GrammaticalRelation reln2;
            if (arcLabel == null) continue;
            try {
                reln2 = GrammaticalRelation.getRelation(arcLabel);
            }
            catch (Exception e) {
                continue;
            }
            if (!reln.isAncestor(reln2)) continue;
            reln = reln2;
        }
        return reln;
    }

    public static List<GrammaticalRelation> getListGrammaticalRelation(TreeGraphNode gov, TreeGraphNode dep) {
        ArrayList<GrammaticalRelation> list = new ArrayList<GrammaticalRelation>();
        TreeGraphNode govH = gov.highestNodeWithSameHead();
        TreeGraphNode depH = dep.highestNodeWithSameHead();
        Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels = govH.arcLabelsToNode(depH);
        if (dep != depH) {
            Set<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>> arcLabels2 = govH.arcLabelsToNode(dep);
            arcLabels.addAll(arcLabels2);
        }
        for (Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation> arcLabel : arcLabels) {
            if (arcLabel == null) continue;
            GrammaticalRelation reln = GrammaticalRelation.getRelation(arcLabel);
            boolean descendantFound = false;
            for (int index = 0; index < list.size(); ++index) {
                GrammaticalRelation gr = (GrammaticalRelation)list.get(index);
                if (gr.isAncestor(reln)) {
                    list.remove(index);
                    --index;
                    continue;
                }
                if (!reln.isAncestor(gr)) continue;
                descendantFound = true;
            }
            if (descendantFound) continue;
            list.add(reln);
        }
        return list;
    }

    public Collection<TypedDependency> typedDependencies() {
        return this.typedDependencies(false);
    }

    public Collection<TypedDependency> allTypedDependencies() {
        return this.typedDependencies(true);
    }

    public List<TypedDependency> typedDependencies(boolean includeExtras) {
        ArrayList<TypedDependency> deps = new ArrayList<TypedDependency>(includeExtras ? this.allTypedDependencies : this.typedDependencies);
        this.correctDependencies(deps);
        return deps;
    }

    public Collection<TypedDependency> typedDependenciesCollapsed() {
        return this.typedDependenciesCollapsed(false);
    }

    public Collection<TypedDependency> typedDependenciesCollapsedTree() {
        List<TypedDependency> tdl = this.typedDependencies(false);
        this.collapseDependenciesTree(tdl);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCollapsed(boolean includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(false);
        if (includeExtras) {
            GrammaticalStructure.getTreeDeps(this.root(), tdl, new NoPunctTypedDependencyFilter(this.puncFilter));
        }
        this.collapseDependencies(tdl, false, includeExtras);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCCprocessed(boolean includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(false);
        if (includeExtras) {
            GrammaticalStructure.getTreeDeps(this.root(), tdl, new NoPunctTypedDependencyFilter(this.puncFilter));
        }
        this.collapseDependencies(tdl, true, includeExtras);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCCprocessed() {
        return this.typedDependenciesCCprocessed(true);
    }

    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, boolean includeExtras) {
    }

    protected void collapseDependenciesTree(List<TypedDependency> list) {
    }

    protected void correctDependencies(Collection<TypedDependency> list) {
    }

    public List<String> getDependencyPath(int nodeIndex, int rootIndex) {
        TreeGraphNode node = this.getNodeByIndex(nodeIndex);
        TreeGraphNode rootTree = this.getNodeByIndex(rootIndex);
        return GrammaticalStructure.getDependencyPath(node, rootTree);
    }

    private static List<String> getDependencyPath(TreeGraphNode node, TreeGraphNode root) {
        ArrayList<String> path = new ArrayList<String>();
        while (!node.equals(root)) {
            TreeGraphNode gov = GrammaticalStructure.getGovernor(node);
            List<GrammaticalRelation> relations = GrammaticalStructure.getListGrammaticalRelation(gov, node);
            StringBuilder sb = new StringBuilder();
            for (GrammaticalRelation relation : relations) {
                sb.append(sb.length() == 0 ? "" : "+").append(relation.toString());
            }
            path.add(sb.toString());
            node = gov;
        }
        return path;
    }

    private static Map<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>, Set<TreeGraphNode>> getAllDependents(TreeGraphNode node) {
        Map<Class<? extends GrammaticalRelation.GrammaticalRelationAnnotation>, Set<TreeGraphNode>> newMap = Generics.newHashMap();
        for (Class<?> o : node.label.keySet()) {
            if (!GrammaticalRelation.GrammaticalRelationAnnotation.class.isAssignableFrom(o)) continue;
            Class typedKey = (Class)ErasureUtils.uncheckedCast(o);
            newMap.put(typedKey, (Set<TreeGraphNode>)node.label.get(typedKey));
        }
        return newMap;
    }

    public static boolean isConnected(Collection<TypedDependency> list) {
        return GrammaticalStructure.getRoots(list).size() <= 1;
    }

    public static Collection<TypedDependency> getRoots(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> roots = new ArrayList<TypedDependency>();
        Set<TreeGraphNode> deps = Generics.newHashSet();
        for (TypedDependency typedDep : list) {
            deps.add(typedDep.dep());
        }
        Set<TreeGraphNode> govs = Generics.newHashSet();
        for (TypedDependency typedDep : list) {
            TreeGraphNode gov = typedDep.gov();
            if (!deps.contains(gov) && !govs.contains(gov)) {
                roots.add(typedDep);
            }
            govs.add(gov);
        }
        return roots;
    }

    public static void printDependencies(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep) {
        System.out.println(GrammaticalStructure.dependenciesToString(gs, deps, tree, conllx, extraSep));
    }

    public static String dependenciesToString(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep) {
        StringBuilder bf;
        block9: {
            Map<Integer, Integer> indexToPos;
            block10: {
                block8: {
                    bf = new StringBuilder();
                    indexToPos = Generics.newHashMap();
                    indexToPos.put(0, 0);
                    List gsLeaves = gs.root.getLeaves();
                    for (int i = 0; i < gsLeaves.size(); ++i) {
                        TreeGraphNode leaf = (TreeGraphNode)gsLeaves.get(i);
                        indexToPos.put(leaf.label.index(), i + 1);
                    }
                    if (!conllx) break block8;
                    List leaves = tree.getLeaves();
                    ArrayList<String> words = new ArrayList<String>(leaves.size());
                    ArrayList<String> pos = new ArrayList<String>(leaves.size());
                    String[] relns = new String[leaves.size()];
                    int[] govs = new int[leaves.size()];
                    for (Tree leaf : leaves) {
                        words.add(leaf.value());
                        pos.add(leaf.parent(tree).value());
                    }
                    for (TypedDependency dep : deps) {
                        int depPos = indexToPos.get(dep.dep().index()) - 1;
                        govs[depPos] = indexToPos.get(dep.gov().index());
                        relns[depPos] = dep.reln().toString();
                    }
                    for (int i = 0; i < relns.length; ++i) {
                        String out2 = String.format("%d\t%s\t_\t%s\t%s\t_\t%d\t%s\t_\t_\n", i + 1, words.get(i), pos.get(i), pos.get(i), govs[i], relns[i] != null ? relns[i] : "erased");
                        bf.append(out2);
                    }
                    break block9;
                }
                if (!extraSep) break block10;
                ArrayList<TypedDependency> extraDeps = new ArrayList<TypedDependency>();
                for (TypedDependency dep : deps) {
                    if (dep.extra()) {
                        extraDeps.add(dep);
                        continue;
                    }
                    bf.append(GrammaticalStructure.toStringIndex(dep, indexToPos));
                    bf.append("\n");
                }
                if (extraDeps.isEmpty()) break block9;
                bf.append("======\n");
                for (TypedDependency dep : extraDeps) {
                    bf.append(GrammaticalStructure.toStringIndex(dep, indexToPos));
                    bf.append("\n");
                }
                break block9;
            }
            for (TypedDependency dep : deps) {
                bf.append(GrammaticalStructure.toStringIndex(dep, indexToPos));
                bf.append("\n");
            }
        }
        return bf.toString();
    }

    private static String toStringIndex(TypedDependency td, Map<Integer, Integer> indexToPos) {
        TreeGraphNode gov = td.gov();
        TreeGraphNode dep = td.dep();
        return td.reln() + "(" + gov.value() + "-" + indexToPos.get(gov.index()) + gov.toPrimes() + ", " + dep.value() + "-" + indexToPos.get(dep.index()) + dep.toPrimes() + ")";
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticStructureCollection(String fileName, Map<String, GrammaticalRelation> shortNameToGRel, GrammaticalStructureFromDependenciesFactory factory) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
        LinkedList<GrammaticalStructure> gsList = new LinkedList<GrammaticalStructure>();
        ArrayList<List<String>> tokenFields = new ArrayList<List<String>>();
        String inline = reader.readLine();
        while (inline != null) {
            if (!"".equals(inline)) {
                List<String> fields = Arrays.asList(inline.split("\t"));
                if (fields.size() != 10) {
                    throw new RuntimeException(String.format("Error (line %d): 10 fields expected but %d are present", reader.getLineNumber(), fields.size()));
                }
                tokenFields.add(fields);
            } else if (!tokenFields.isEmpty()) {
                gsList.add(GrammaticalStructure.buildCoNNLXGrammaticStructure(tokenFields, shortNameToGRel, factory));
                tokenFields = new ArrayList();
            }
            inline = reader.readLine();
        }
        return gsList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GrammaticalStructure buildCoNNLXGrammaticStructure(List<List<String>> tokenFields, Map<String, GrammaticalRelation> shortNameToGRel, GrammaticalStructureFromDependenciesFactory factory) {
        ArrayList<TreeGraphNode> tgWordNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
        ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
        SemanticHeadFinder headFinder = new SemanticHeadFinder();
        for (List<String> fields : tokenFields) {
            TreeGraphNode word = new TreeGraphNode(new Word(fields.get(1)));
            TreeGraphNode pos = new TreeGraphNode(new Word(fields.get(3)));
            tgWordNodes.add(word);
            tgPOSNodes.add(pos);
            Tree[] childArr = new TreeGraphNode[]{word};
            pos.setChildren(childArr);
            word.setParent(pos);
            pos.percolateHeads(headFinder);
        }
        TreeGraphNode root = new TreeGraphNode(new Word("ROOT-" + (tgWordNodes.size() + 1)));
        root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
        ArrayList<TypedDependency> tdeps = new ArrayList<TypedDependency>(tgWordNodes.size());
        TreeGraphNode dependencyRoot = new TreeGraphNode(new Word("ROOT"));
        dependencyRoot.setIndex(0);
        for (int i = 0; i < tgWordNodes.size(); ++i) {
            TypedDependency tdep;
            String parentIdStr = tokenFields.get(i).get(6);
            if (parentIdStr == null || parentIdStr.equals("")) continue;
            int parentId = Integer.parseInt(parentIdStr) - 1;
            String grelString = tokenFields.get(i).get(7);
            if (grelString.equals("null")) continue;
            GrammaticalRelation grel = shortNameToGRel.get(grelString.toLowerCase());
            if (grel == null) {
                if (!grelString.toLowerCase().equals("root")) throw new RuntimeException("Unknown grammatical relation '" + grelString + "' fields: " + tokenFields.get(i) + "\nNode: " + tgWordNodes.get(i) + "\n" + "Known Grammatical relations: [" + shortNameToGRel.keySet() + "]");
                tdep = new TypedDependency(GrammaticalRelation.ROOT, dependencyRoot, (TreeGraphNode)tgWordNodes.get(i));
            } else {
                if (parentId >= tgWordNodes.size()) {
                    System.err.printf("Warning: Invalid Parent Id %d Sentence Length: %d%n", parentId + 1, tgWordNodes.size());
                    System.err.printf("         Assigning to root (0)%n", new Object[0]);
                    parentId = -1;
                }
                tdep = new TypedDependency(grel, parentId == -1 ? root : (TreeGraphNode)tgWordNodes.get(parentId), (TreeGraphNode)tgWordNodes.get(i));
            }
            tdeps.add(tdep);
        }
        return factory.build(tdeps, root);
    }

    private static String[] parseClassConstructArgs(String namePlusArgs) {
        String[] args = StringUtils.EMPTY_STRING_ARRAY;
        String name = namePlusArgs;
        if (namePlusArgs.matches(".*\\([^)]*\\)$")) {
            String argStr = namePlusArgs.replaceFirst("^.*\\(([^)]*)\\)$", "$1");
            args = argStr.split(",");
            name = namePlusArgs.replaceFirst("\\([^)]*\\)$", "");
        }
        String[] tokens = new String[1 + args.length];
        tokens[0] = name;
        System.arraycopy(args, 0, tokens, 1, args.length);
        return tokens;
    }

    private static DependencyReader loadAlternateDependencyReader(String altDepReaderName) {
        DependencyReader altDepReader;
        Class<?> cl;
        Class<DependencyReader> altDepReaderClass = null;
        String[] toks = GrammaticalStructure.parseClassConstructArgs(altDepReaderName);
        altDepReaderName = toks[0];
        String[] depReaderArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depReaderArgs, 0, toks.length - 1);
        try {
            cl = Class.forName(altDepReaderName);
            altDepReaderClass = cl.asSubclass(DependencyReader.class);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (altDepReaderClass == null) {
            try {
                cl = Class.forName("edu.stanford.nlp.trees." + altDepReaderName);
                altDepReaderClass = cl.asSubclass(DependencyReader.class);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (altDepReaderClass == null) {
            System.err.println("Can't load dependency reader " + altDepReaderName + " or edu.stanford.nlp.trees." + altDepReaderName);
            return null;
        }
        if (depReaderArgs.length == 0) {
            try {
                altDepReader = altDepReaderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                System.err.println("No argument constructor to " + altDepReaderName + " is not public");
                return null;
            }
        }
        try {
            altDepReader = altDepReaderClass.getConstructor(String[].class).newInstance(new Object[]{depReaderArgs});
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            System.err.println(depReaderArgs.length + " argument constructor to " + altDepReaderName + " is not public.");
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            System.err.println("String arguments constructor to " + altDepReaderName + " does not exist.");
            return null;
        }
        return altDepReader;
    }

    private static DependencyPrinter loadAlternateDependencyPrinter(String altDepPrinterName) {
        Class<?> cl;
        Class<DependencyPrinter> altDepPrinterClass = null;
        String[] toks = GrammaticalStructure.parseClassConstructArgs(altDepPrinterName);
        altDepPrinterName = toks[0];
        Object[] depPrintArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depPrintArgs, 0, toks.length - 1);
        try {
            cl = Class.forName(altDepPrinterName);
            altDepPrinterClass = cl.asSubclass(DependencyPrinter.class);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (altDepPrinterClass == null) {
            try {
                cl = Class.forName("edu.stanford.nlp.trees." + altDepPrinterName);
                altDepPrinterClass = cl.asSubclass(DependencyPrinter.class);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (altDepPrinterClass == null) {
            System.err.printf("Unable to load alternative printer %s or %s. Is your classpath set correctly?\n", altDepPrinterName, "edu.stanford.nlp.trees." + altDepPrinterName);
            return null;
        }
        try {
            DependencyPrinter depPrinter = depPrintArgs.length == 0 ? altDepPrinterClass.newInstance() : altDepPrinterClass.getConstructor(String[].class).newInstance(new Object[]{depPrintArgs});
            return depPrinter;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            if (depPrintArgs == null) {
                System.err.printf("Can't find no-argument constructor %s().\n", altDepPrinterName);
            } else {
                System.err.printf("Can't find constructor %s(%s).\n", altDepPrinterName, Arrays.toString(depPrintArgs));
            }
            return null;
        }
    }

    private static Function<List<? extends HasWord>, Tree> loadParser(String parserFile, String parserOptions, boolean makeCopulaHead) {
        Function lp;
        if (parserFile == null || "".equals(parserFile)) {
            parserFile = DEFAULT_PARSER_FILE;
            if (parserOptions == null) {
                parserOptions = "-retainTmpSubcategories";
            }
        }
        if (parserOptions == null) {
            parserOptions = "";
        }
        if (makeCopulaHead) {
            parserOptions = "-makeCopulaHead " + parserOptions;
        }
        parserOptions = parserOptions.trim();
        try {
            Class[] classes = new Class[]{String.class, String[].class};
            Method method = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getMethod("loadModel", classes);
            String[] opts = new String[]{};
            if (parserOptions.length() > 0) {
                opts = parserOptions.split(" +");
            }
            lp = (Function)method.invoke(null, parserFile, opts);
        }
        catch (Exception cnfe) {
            throw new RuntimeException(cnfe);
        }
        return lp;
    }

    public static void main(String[] args) {
        boolean portray;
        MemoryTreebank tb;
        Iterable<Tree> trees = tb = new MemoryTreebank(new TreeNormalizer());
        Iterable<GrammaticalStructure> gsBank = null;
        Properties props = StringUtils.argsToProperties(args);
        String encoding = props.getProperty("encoding", "utf-8");
        try {
            System.setOut(new PrintStream((OutputStream)System.out, true, encoding));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String conllXFileName = props.getProperty("conllxFile");
        String altDepPrinterName = props.getProperty("altprinter");
        String altDepReaderName = props.getProperty("altreader");
        String altDepReaderFilename = props.getProperty("altreaderfile");
        String filter = props.getProperty("filter");
        boolean makeCopulaHead = props.getProperty("makeCopulaHead") != null;
        String tLPP = props.getProperty("tLPP", "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams");
        TreebankLangParserParams params = (TreebankLangParserParams)ReflectionLoading.loadByReflection(tLPP, new Object[0]);
        if (makeCopulaHead) {
            String[] options = new String[]{"-makeCopulaHead"};
            params.setOptionFlag(options, 0);
        }
        if (sentFileName == null && (altDepReaderName == null || altDepReaderFilename == null) && treeFileName == null && conllXFileName == null && filter == null) {
            try {
                System.err.println("Usage: java GrammaticalStructure [options]* [-sentFile|-treeFile|-conllxFile file] [-testGraph]");
                System.err.println("  options: -basic, -collapsed, -CCprocessed [the default], -collapsedTree, -parseTree, -test, -parserFile file, -conllx, -keepPunct, -altprinter -altreader -altreaderfile");
                PennTreeReader tr = new PennTreeReader(new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"));
                tb.add(tr.readTree());
            }
            catch (Exception e) {
                System.err.println("Horrible error: " + e);
                e.printStackTrace();
            }
        } else {
            if (altDepReaderName != null && altDepReaderFilename != null) {
                DependencyReader altDepReader = GrammaticalStructure.loadAlternateDependencyReader(altDepReaderName);
                try {
                    gsBank = altDepReader.readDependencies(altDepReaderFilename);
                }
                catch (IOException e) {
                    System.err.println("Error reading " + altDepReaderFilename);
                    return;
                }
            }
            if (treeFileName != null) {
                tb.loadPath(treeFileName);
            } else if (filter != null) {
                tb.load(new BufferedReader(new InputStreamReader(System.in)));
            } else {
                if (conllXFileName != null) {
                    try {
                        gsBank = params.readGrammaticalStructureFromFile(conllXFileName);
                    }
                    catch (RuntimeIOException e) {
                        System.err.println("Error reading " + conllXFileName);
                        return;
                    }
                }
                String parserFile = props.getProperty("parserFile");
                String parserOpts = props.getProperty("parserOpts");
                boolean tokenized = props.getProperty("tokenized") != null;
                Function<List<? extends HasWord>, Tree> lp = GrammaticalStructure.loadParser(parserFile, parserOpts, makeCopulaHead);
                trees = new LazyLoadTreesByParsing(sentFileName, encoding, tokenized, lp);
                try {
                    Method method = lp.getClass().getMethod("getTLPParams", new Class[0]);
                    params = (TreebankLangParserParams)method.invoke(lp, new Object[0]);
                }
                catch (Exception cnfe) {
                    throw new RuntimeException(cnfe);
                }
            }
        }
        boolean basic = props.getProperty("basic") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean CCprocessed = props.getProperty("CCprocessed") != null;
        boolean tree = props.getProperty("collapsedTree") != null;
        boolean nonCollapsed = props.getProperty("nonCollapsed") != null;
        boolean extraSep = props.getProperty("extraSep") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean test = props.getProperty("test") != null;
        boolean keepPunct = props.getProperty("keepPunct") != null;
        boolean conllx = props.getProperty("conllx") != null;
        boolean checkConnected = props.getProperty("checkConnected") != null;
        boolean bl = portray = props.getProperty("portray") != null;
        if (conllx) {
            keepPunct = true;
        }
        DependencyPrinter altDepPrinter = null;
        if (altDepPrinterName != null) {
            altDepPrinter = GrammaticalStructure.loadAlternateDependencyPrinter(altDepPrinterName);
        }
        Method m = null;
        if (test) {
            try {
                Class<?> sgf = Class.forName("edu.stanford.nlp.semgraph.SemanticGraphFactory");
                m = sgf.getDeclaredMethod("makeFromTree", GrammaticalStructure.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Filter.class, String.class, Integer.TYPE);
            }
            catch (Exception e) {
                System.err.println("Test cannot check for cycles in tree format (classes not available)");
            }
        }
        if (gsBank == null) {
            gsBank = new TreeBankGrammaticalStructureWrapper(trees, keepPunct, params);
        }
        for (GrammaticalStructure gs : gsBank) {
            Tree t = gsBank instanceof TreeBankGrammaticalStructureWrapper ? ((TreeBankGrammaticalStructureWrapper)gsBank).getOriginalTree(gs) : gs.root();
            if (test) {
                System.out.println("============= parse tree =======================");
                t.pennPrint();
                System.out.println();
                System.out.println("------------- GrammaticalStructure -------------");
                System.out.println(gs);
                System.out.println("------------- basic dependencies ---------------");
                System.out.println(StringUtils.join(gs.typedDependencies(false), "\n"));
                System.out.println("------------- non-collapsed dependencies (basic + extra) ---------------");
                System.out.println(StringUtils.join(gs.typedDependencies(true), "\n"));
                System.out.println("------------- collapsed dependencies -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
                System.out.println("------------- collapsed dependencies tree -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println("------------- CCprocessed dependencies --------");
                System.out.println(StringUtils.join(gs.typedDependenciesCCprocessed(true), "\n"));
                System.out.println("-----------------------------------------------");
                boolean connected = GrammaticalStructure.isConnected(gs.typedDependenciesCollapsed(true));
                System.out.println("collapsed dependencies form a connected graph: " + connected);
                if (!connected) {
                    System.out.println("possible offending nodes: " + GrammaticalStructure.getRoots(gs.typedDependenciesCollapsed(true)));
                }
                if (m != null) {
                    try {
                        Object semGraph = m.invoke(null, gs, false, true, false, false, false, false, null, null, 0);
                        Class<?> sg = Class.forName("edu.stanford.nlp.semgraph.SemanticGraph");
                        Method mDag = sg.getDeclaredMethod("isDag", new Class[0]);
                        boolean isDag = (Boolean)mDag.invoke(semGraph, new Object[0]);
                        System.out.println("tree dependencies form a DAG: " + isDag);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (parseTree) {
                    System.out.println("============= parse tree =======================");
                    t.pennPrint();
                    System.out.println();
                }
                if (basic) {
                    if (collapsed || CCprocessed || tree || nonCollapsed) {
                        System.out.println("------------- basic dependencies ---------------");
                    }
                    if (altDepPrinter == null) {
                        GrammaticalStructure.printDependencies(gs, gs.typedDependencies(false), t, conllx, false);
                    } else {
                        System.out.println(altDepPrinter.dependenciesToString(gs, gs.typedDependencies(false), t));
                    }
                }
                if (nonCollapsed) {
                    if (basic || CCprocessed || collapsed || tree) {
                        System.out.println("----------- non-collapsed dependencies (basic + extra) -----------");
                    }
                    GrammaticalStructure.printDependencies(gs, gs.allTypedDependencies(), t, conllx, extraSep);
                }
                if (collapsed) {
                    if (basic || CCprocessed || tree || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies -----------");
                    }
                    GrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsed(true), t, conllx, false);
                }
                if (CCprocessed) {
                    if (basic || collapsed || tree || nonCollapsed) {
                        System.out.println("---------- CCprocessed dependencies ----------");
                    }
                    List<TypedDependency> deps = gs.typedDependenciesCCprocessed(true);
                    if (checkConnected && !GrammaticalStructure.isConnected(deps)) {
                        System.err.println("Graph is not connected for:");
                        System.err.println(t);
                        System.err.println("possible offending nodes: " + GrammaticalStructure.getRoots(deps));
                    }
                    GrammaticalStructure.printDependencies(gs, deps, t, conllx, false);
                }
                if (tree) {
                    if (basic || CCprocessed || collapsed || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies tree -----------");
                    }
                    GrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsedTree(), t, conllx, false);
                }
                if (!(basic || collapsed || CCprocessed || tree || nonCollapsed)) {
                    GrammaticalStructure.printDependencies(gs, gs.typedDependenciesCCprocessed(true), t, conllx, false);
                }
            }
            if (!portray) continue;
            try {
                Class<?> sgu = Class.forName("edu.stanford.nlp.semgraph.SemanticGraphUtils");
                Method mRender = sgu.getDeclaredMethod("render", GrammaticalStructure.class, String.class);
                mRender.invoke(null, gs, "Collapsed, CC processed deps");
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't use swing to portray semantic graph", e);
            }
        }
    }

    static class LazyLoadTreesByParsing
    implements Iterable<Tree> {
        final Reader reader;
        final String filename;
        final boolean tokenized;
        final String encoding;
        final Function<List<? extends HasWord>, Tree> lp;

        public LazyLoadTreesByParsing(String filename, String encoding, boolean tokenized, Function<List<? extends HasWord>, Tree> lp) {
            this.filename = filename;
            this.encoding = encoding;
            this.reader = null;
            this.tokenized = tokenized;
            this.lp = lp;
        }

        public LazyLoadTreesByParsing(Reader reader, boolean tokenized, Function<List<? extends HasWord>, Tree> lp) {
            this.filename = null;
            this.encoding = null;
            this.reader = reader;
            this.tokenized = tokenized;
            this.lp = lp;
        }

        @Override
        public Iterator<Tree> iterator() {
            BufferedReader iReader;
            if (this.reader != null) {
                iReader = new BufferedReader(this.reader);
            } else {
                try {
                    iReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), this.encoding));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Iterator<Tree>(){
                String line = null;

                @Override
                public boolean hasNext() {
                    if (this.line != null) {
                        return true;
                    }
                    try {
                        this.line = iReader.readLine();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.line == null) {
                        try {
                            if (LazyLoadTreesByParsing.this.reader == null) {
                                iReader.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return false;
                    }
                    return true;
                }

                @Override
                public Tree next() {
                    if (this.line == null) {
                        throw new NoSuchElementException();
                    }
                    StringReader lineReader = new StringReader(this.line);
                    this.line = null;
                    List words = LazyLoadTreesByParsing.this.tokenized ? WhitespaceTokenizer.newWordWhitespaceTokenizer(lineReader).tokenize() : PTBTokenizer.newPTBTokenizer(lineReader).tokenize();
                    if (!words.isEmpty()) {
                        Tree parseTree = LazyLoadTreesByParsing.this.lp.apply(words);
                        return parseTree;
                    }
                    return new SimpleTree();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class TreeBankGrammaticalStructureWrapper
    implements Iterable<GrammaticalStructure> {
        private final Iterable<Tree> trees;
        private final boolean keepPunct;
        private final TreebankLangParserParams params;
        private final Map<GrammaticalStructure, Tree> origTrees = new WeakHashMap<GrammaticalStructure, Tree>();

        public TreeBankGrammaticalStructureWrapper(Iterable<Tree> wrappedTrees, boolean keepPunct, TreebankLangParserParams params) {
            this.trees = wrappedTrees;
            this.keepPunct = keepPunct;
            this.params = params;
        }

        @Override
        public Iterator<GrammaticalStructure> iterator() {
            return new GsIterator();
        }

        public Tree getOriginalTree(GrammaticalStructure gs) {
            return this.origTrees.get(gs);
        }

        private class GsIterator
        implements Iterator<GrammaticalStructure> {
            private final Iterator<Tree> tbIterator;
            private final Filter<String> puncFilter;
            private final HeadFinder hf;
            private GrammaticalStructure next;

            public GsIterator() {
                this.tbIterator = TreeBankGrammaticalStructureWrapper.this.trees.iterator();
                this.puncFilter = TreeBankGrammaticalStructureWrapper.this.keepPunct ? Filters.acceptFilter() : new PennTreebankLanguagePack().punctuationWordRejectFilter();
                this.hf = TreeBankGrammaticalStructureWrapper.this.params.typedDependencyHeadFinder();
                this.primeGs();
            }

            private void primeGs() {
                GrammaticalStructure gs = null;
                while (gs == null && this.tbIterator.hasNext()) {
                    Tree t = this.tbIterator.next();
                    if (t == null) continue;
                    try {
                        gs = TreeBankGrammaticalStructureWrapper.this.params.getGrammaticalStructure(t, this.puncFilter, this.hf);
                        TreeBankGrammaticalStructureWrapper.this.origTrees.put(gs, t);
                        this.next = gs;
                        return;
                    }
                    catch (NullPointerException npe) {
                        System.err.println("Bung (empty?) tree caused below dump. Continuing....");
                        npe.printStackTrace();
                    }
                }
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public GrammaticalStructure next() {
                GrammaticalStructure ret = this.next;
                if (ret == null) {
                    throw new NoSuchElementException();
                }
                this.primeGs();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class NameComparator<X>
    implements Comparator<X> {
        private NameComparator() {
        }

        @Override
        public int compare(X o1, X o2) {
            String n1 = o1.toString();
            String n2 = o2.toString();
            return n1.compareTo(n2);
        }
    }

    private static class NoPunctTypedDependencyFilter
    implements Filter<TypedDependency> {
        private Filter<String> npf;
        private static final long serialVersionUID = -2872766864289207468L;

        NoPunctTypedDependencyFilter(Filter<String> f) {
            this.npf = f;
        }

        @Override
        public boolean accept(TypedDependency d) {
            if (d == null) {
                return false;
            }
            TreeGraphNode s = d.dep();
            if (s == null) {
                return false;
            }
            CoreLabel l = s.label();
            if (l == null) {
                return false;
            }
            return this.npf.accept(l.value());
        }
    }

    private static class NoPunctFilter
    implements Filter<Dependency<Label, Label, Object>> {
        private Filter<String> npf;
        private static final long serialVersionUID = -2319891944796663180L;

        NoPunctFilter(Filter<String> f) {
            this.npf = f;
        }

        @Override
        public boolean accept(Dependency<Label, Label, Object> d) {
            if (d == null) {
                return false;
            }
            Label lab = d.dependent();
            if (lab == null) {
                return false;
            }
            return this.npf.accept(lab.value());
        }
    }
}

