/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.ud.CoNLLUUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.IntPair;
import java.util.HashMap;
import java.util.List;

public class CoNLLUDocumentWriter {
    private static final String LRB_PATTERN = "(?i)-LRB-";
    private static final String RRB_PATTERN = "(?i)-RRB-";

    public String printSemanticGraph(SemanticGraph sg) {
        return this.printSemanticGraph(sg, true);
    }

    public String printSemanticGraph(SemanticGraph sg, boolean unescapeParenthesis) {
        boolean isTree = SemanticGraphUtils.isTree(sg);
        StringBuilder sb = new StringBuilder();
        for (String comment : sg.getComments()) {
            sb.append(comment).append("\n");
        }
        for (IndexedWord token : sg.vertexListSorted()) {
            String relnName;
            IntPair tokenSpan;
            if (token.containsKey(CoreAnnotations.CoNLLUTokenSpanAnnotation.class) && (tokenSpan = (IntPair)token.get(CoreAnnotations.CoNLLUTokenSpanAnnotation.class)).getSource() == token.index()) {
                String range = String.format("%d-%d", tokenSpan.getSource(), tokenSpan.getTarget());
                sb.append(String.format("%s\t%s\t_\t_\t_\t_\t_\t_\t_\t_%n", range, token.originalText()));
            }
            String govIdx = null;
            GrammaticalRelation reln = null;
            HashMap<String, String> enhancedDependencies = new HashMap<String, String>();
            for (IndexedWord parent : sg.getParents(token)) {
                SemanticGraphEdge edge = sg.getEdge(parent, token);
                if (govIdx == null && !edge.isExtra()) {
                    govIdx = parent.toCopyIndex();
                    reln = edge.getRelation();
                }
                enhancedDependencies.put(parent.toCopyIndex(), edge.getRelation().toString());
            }
            String additionalDepsString = isTree ? "_" : CoNLLUUtils.toExtraDepsString(enhancedDependencies);
            String word = token.word();
            String featuresString = CoNLLUUtils.toFeatureString((HashMap)token.get(CoreAnnotations.CoNLLUFeats.class));
            String pos = token.getString(CoreAnnotations.PartOfSpeechAnnotation.class, "_");
            String upos = token.getString(CoreAnnotations.CoarseTagAnnotation.class, "_");
            String misc = token.getString(CoreAnnotations.CoNLLUMisc.class, "_");
            String lemma = token.getString(CoreAnnotations.LemmaAnnotation.class, "_");
            String string = relnName = reln == null ? "_" : reln.toString();
            if (govIdx == null && sg.getRoots().contains(token)) {
                govIdx = "0";
                relnName = GrammaticalRelation.ROOT.toString();
                String string2 = additionalDepsString = isTree ? "_" : "0:" + relnName;
            }
            if (unescapeParenthesis) {
                word = word.replaceAll(LRB_PATTERN, "(");
                word = word.replaceAll(RRB_PATTERN, ")");
                lemma = lemma.replaceAll(LRB_PATTERN, "(");
                lemma = lemma.replaceAll(RRB_PATTERN, ")");
            }
            sb.append(String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s%n", token.toCopyIndex(), word, lemma, upos, pos, featuresString, govIdx, relnName, additionalDepsString, misc));
        }
        sb.append("\n");
        return sb.toString();
    }

    public String printPOSAnnotations(CoreMap sentence) {
        StringBuilder sb = new StringBuilder();
        for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
            String upos = token.getString(CoreAnnotations.CoarseTagAnnotation.class, "_");
            String lemma = token.getString(CoreAnnotations.LemmaAnnotation.class, "_");
            String pos = token.getString(CoreAnnotations.PartOfSpeechAnnotation.class, "_");
            String featuresString = CoNLLUUtils.toFeatureString((HashMap)token.get(CoreAnnotations.CoNLLUFeats.class));
            String misc = token.getString(CoreAnnotations.CoNLLUMisc.class, "_");
            sb.append(String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s%n", token.index(), token.word(), lemma, upos, pos, featuresString, "_", "_", "_", misc));
        }
        sb.append("\n");
        return sb.toString();
    }
}

