/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.ud;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import edu.stanford.nlp.trees.UniversalPOSMapper;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentReader;
import edu.stanford.nlp.trees.ud.CoNLLUDocumentWriter;
import edu.stanford.nlp.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class UniversalDependenciesConverter {
    public static String NER_COMBINER_NAME = "edu.stanford.nlp.ie.NERClassifierCombiner";
    private static final boolean USE_NAME = System.getProperty("UDUseNameRelation") != null;
    private static Morphology MORPH = new Morphology();
    private static Object NER_TAGGER = null;
    private static Method NER_CLASSIFY_METHOD = null;

    private UniversalDependenciesConverter() {
    }

    private static GrammaticalStructure semanticGraphToGrammaticalStructure(SemanticGraph sg) {
        List deps = (List)sg.typedDependencies();
        IndexedWord root = ((TypedDependency)deps.get(0)).gov();
        TreeGraphNode rootNode = new TreeGraphNode(root);
        UniversalEnglishGrammaticalStructure gs = new UniversalEnglishGrammaticalStructure(deps, rootNode);
        return gs;
    }

    private static SemanticGraph convertBasicToEnhanced(SemanticGraph sg) {
        GrammaticalStructure gs = UniversalDependenciesConverter.semanticGraphToGrammaticalStructure(sg);
        return SemanticGraphFactory.generateEnhancedDependencies(gs);
    }

    private static SemanticGraph convertBasicToEnhancedPlusPlus(SemanticGraph sg) {
        GrammaticalStructure gs = UniversalDependenciesConverter.semanticGraphToGrammaticalStructure(sg);
        return SemanticGraphFactory.generateEnhancedPlusPlusDependencies(gs);
    }

    private static SemanticGraph convertTreeToBasic(Tree tree) {
        UniversalDependenciesConverter.addLemmata(tree);
        UniversalDependenciesConverter.addNERTags(tree);
        SemanticGraph sg = SemanticGraphFactory.makeFromTree(tree, SemanticGraphFactory.Mode.BASIC, GrammaticalStructure.Extras.NONE, null, false, true);
        UniversalDependenciesConverter.addLemmata(sg);
        if (USE_NAME) {
            UniversalDependenciesConverter.addNERTags(sg);
        }
        return sg;
    }

    private static void addLemmata(SemanticGraph sg) {
        sg.vertexListSorted().forEach(w -> {
            if (w.lemma() == null) {
                w.setLemma(MORPH.lemma(w.word(), w.tag()));
            }
        });
    }

    private static void addLemmata(Tree tree) {
        tree.yield().forEach(l -> {
            CoreLabel w = (CoreLabel)l;
            if (w.lemma() == null) {
                w.setLemma(MORPH.lemma(w.word(), w.tag()));
            }
        });
    }

    private static boolean isNERClassifierCombinerPresent() {
        try {
            Class<?> clazz = Class.forName(NER_COMBINER_NAME);
        }
        catch (Exception ex) {
            System.err.println("Warning: edu.stanford.nlp.ie.NERClassifierCombiner not found - not applying NER tags!");
            return false;
        }
        return true;
    }

    private static void setupNERTagger() {
        try {
            Class<?> NER_TAGGER_CLASS = Class.forName(NER_COMBINER_NAME);
            Method createMethod = NER_TAGGER_CLASS.getDeclaredMethod("createNERClassifierCombiner", String.class, Properties.class);
            NER_TAGGER = createMethod.invoke(null, null, new Properties());
            NER_CLASSIFY_METHOD = NER_TAGGER_CLASS.getDeclaredMethod("classify", List.class);
        }
        catch (Exception ex) {
            System.err.println("Error setting up NERClassifierCombiner!  Not applying NER tags!");
        }
    }

    private static void addNERTags(SemanticGraph sg) {
        if (UniversalDependenciesConverter.isNERClassifierCombinerPresent()) {
            try {
                if (NER_TAGGER == null || NER_CLASSIFY_METHOD == null) {
                    UniversalDependenciesConverter.setupNERTagger();
                }
                List labels = sg.vertexListSorted().stream().map(IndexedWord::backingLabel).collect(Collectors.toList());
                NER_CLASSIFY_METHOD.invoke(NER_TAGGER, labels);
            }
            catch (Exception ex) {
                System.err.println("Error running NERClassifierCombiner on SemanticGraph!  Not applying NER tags!");
            }
        }
    }

    private static void addNERTags(Tree tree) {
        if (UniversalDependenciesConverter.isNERClassifierCombinerPresent()) {
            try {
                if (NER_TAGGER == null || NER_CLASSIFY_METHOD == null) {
                    UniversalDependenciesConverter.setupNERTagger();
                }
                List labels = tree.yield().stream().map(w -> (CoreLabel)w).collect(Collectors.toList());
                NER_CLASSIFY_METHOD.invoke(NER_TAGGER, labels);
            }
            catch (Exception ex) {
                System.err.println("Error running NERClassifierCombiner on Tree!  Not applying NER tags!");
            }
        }
    }

    public static void main(String[] args) {
        TreeToSemanticGraphIterator sgIterator;
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String conlluFileName = props.getProperty("conlluFile");
        String outputRepresentation = props.getProperty("outputRepresentation", "basic");
        if (treeFileName != null) {
            MemoryTreebank tb = new MemoryTreebank(new NPTmpRetainingTreeNormalizer(0, false, 1, false));
            tb.loadPath(treeFileName);
            Iterator<Tree> treeIterator = tb.iterator();
            sgIterator = new TreeToSemanticGraphIterator(treeIterator);
        } else if (conlluFileName != null) {
            CoNLLUDocumentReader reader = new CoNLLUDocumentReader();
            try {
                sgIterator = reader.getIterator(IOUtils.readerFromString(conlluFileName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            System.err.println("No input file specified!");
            System.err.println("");
            System.err.printf("Usage: java %s [-treeFile trees.tree | -conlluFile deptrees.conllu] [-outputRepresentation basic|enhanced|enhanced++ (default: basic)]%n", UniversalDependenciesConverter.class.getCanonicalName());
            return;
        }
        CoNLLUDocumentWriter writer = new CoNLLUDocumentWriter();
        while (sgIterator.hasNext()) {
            SemanticGraph sg = (SemanticGraph)sgIterator.next();
            if (treeFileName != null) {
                Tree tree = sgIterator.getCurrentTree();
                Tree uposTree = UniversalPOSMapper.mapTree(tree);
                List<Label> uposLabels = uposTree.preTerminalYield();
                for (IndexedWord token : sg.vertexListSorted()) {
                    int idx = token.index() - 1;
                    String uposTag = uposLabels.get(idx).value();
                    token.set(CoreAnnotations.CoarseTagAnnotation.class, uposTag);
                }
            } else {
                UniversalDependenciesConverter.addLemmata(sg);
                if (USE_NAME) {
                    UniversalDependenciesConverter.addNERTags(sg);
                }
            }
            if (outputRepresentation.equalsIgnoreCase("enhanced")) {
                sg = UniversalDependenciesConverter.convertBasicToEnhanced(sg);
            } else if (outputRepresentation.equalsIgnoreCase("enhanced++")) {
                sg = UniversalDependenciesConverter.convertBasicToEnhancedPlusPlus(sg);
            }
            System.out.print(writer.printSemanticGraph(sg));
        }
    }

    private static class TreeToSemanticGraphIterator
    implements Iterator<SemanticGraph> {
        private Iterator<Tree> treeIterator;
        private Tree currentTree;

        public TreeToSemanticGraphIterator(Iterator<Tree> treeIterator) {
            this.treeIterator = treeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        @Override
        public SemanticGraph next() {
            Tree t;
            this.currentTree = t = this.treeIterator.next();
            return UniversalDependenciesConverter.convertTreeToBasic(t);
        }

        public Tree getCurrentTree() {
            return this.currentTree;
        }
    }
}

