/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.control.SourceUnit;

public class ClassCompletionVerifier
extends ClassCodeVisitorSupport {
    private ClassNode currentClass;
    private SourceUnit source;

    public ClassCompletionVerifier(SourceUnit source) {
        this.source = source;
    }

    public ClassNode getClassNode() {
        return this.currentClass;
    }

    public void visitClass(ClassNode node) {
        ClassNode oldClass = this.currentClass;
        this.currentClass = node;
        this.checkImplementsAndExtends(node);
        this.checkClassForOverwritingFinal(node);
        this.checkMethodsForOverwritingFinal(node);
        this.checkNoAbstractMethodsNonabstractClass(node);
        super.visitClass(node);
        this.currentClass = oldClass;
    }

    private void checkNoAbstractMethodsNonabstractClass(ClassNode node) {
        if (Modifier.isAbstract(node.getModifiers())) {
            return;
        }
        List abstractMethods = node.getAbstractMethods();
        if (abstractMethods == null) {
            return;
        }
        Iterator iter = abstractMethods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            String methodName = method.getTypeDescriptor();
            this.addError("Can't have an abstract method in a non abstract class. The class '" + node.getName() + "' must be declared abstract or" + " the method '" + methodName + "' must be implemented.", node);
        }
    }

    private void checkAbstractDeclaration(MethodNode methodNode) {
        if (!Modifier.isAbstract(methodNode.getModifiers())) {
            return;
        }
        if (Modifier.isAbstract(this.currentClass.getModifiers())) {
            return;
        }
        this.addError("Can't have an abstract method in a non abstract class. The class '" + this.currentClass.getName() + "' must be declared abstract or the method '" + methodNode.getTypeDescriptor() + "' must not be abstract.", methodNode);
    }

    private void checkClassForOverwritingFinal(ClassNode cn) {
        ClassNode superCN = cn.getSuperClass();
        if (superCN == null) {
            return;
        }
        if (!Modifier.isFinal(superCN.getModifiers())) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("you are not allowed to overwrite the final class ");
        msg.append(superCN.getName());
        msg.append(".");
        this.addError(msg.toString(), cn);
    }

    private void checkImplementsAndExtends(ClassNode node) {
        ClassNode cn = node.getSuperClass();
        if (cn.isInterface()) {
            this.addError("you are not allowed to extend the Interface " + cn.getName() + ", use implements instead", node);
        }
        ClassNode[] interfaces = node.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            cn = interfaces[i];
            if (cn.isInterface()) continue;
            this.addError("you are not allowed to implement the Class " + cn.getName() + ", use extends instead", node);
        }
    }

    private void checkMethodsForOverwritingFinal(ClassNode cn) {
        List l = cn.getMethods();
        Iterator cnIter = l.iterator();
        while (cnIter.hasNext()) {
            MethodNode method = (MethodNode)cnIter.next();
            Parameter[] parameters = method.getParameters();
            for (ClassNode superCN = cn.getSuperClass(); superCN != null; superCN = superCN.getSuperClass()) {
                List methods = superCN.getMethods(method.getName());
                Iterator iter = methods.iterator();
                while (iter.hasNext()) {
                    MethodNode m = (MethodNode)iter.next();
                    Parameter[] np = m.getParameters();
                    if (!this.hasEqualParameterTypes(parameters, np)) continue;
                    if (!Modifier.isFinal(m.getModifiers())) {
                        return;
                    }
                    StringBuffer msg = new StringBuffer();
                    msg.append("you are not allowed to overwrite the final method ").append(method.getName());
                    msg.append("(");
                    boolean semi = false;
                    for (int i = 0; i < parameters.length; ++i) {
                        if (semi) {
                            msg.append(",");
                        } else {
                            semi = true;
                        }
                        msg.append(parameters[i].getType());
                    }
                    msg.append(")");
                    msg.append(" from class ").append(superCN.getName());
                    msg.append(".");
                    this.addError(msg.toString(), method);
                    return;
                }
            }
        }
    }

    private boolean hasEqualParameterTypes(Parameter[] first, Parameter[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            String st;
            String ft = first[i].getType().getName();
            if (ft.equals(st = second[i].getType().getName())) continue;
            return false;
        }
        return true;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        ClassNode type = call.getType();
        if (Modifier.isAbstract(type.getModifiers())) {
            this.addError("cannot create an instance from the abstract class " + type.getName(), call);
        }
        super.visitConstructorCallExpression(call);
    }

    public void visitMethod(MethodNode node) {
        this.checkAbstractDeclaration(node);
        this.checkRepetitiveMethod(node);
        super.visitMethod(node);
    }

    private void checkRepetitiveMethod(MethodNode node) {
        if (node.getName().equals("<clinit>")) {
            return;
        }
        List methods = this.currentClass.getMethods(node.getName());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Parameter[] p2;
            Parameter[] p1;
            MethodNode element = (MethodNode)iter.next();
            if (element == node || !element.getDeclaringClass().equals(node.getDeclaringClass()) || (p1 = node.getParameters()).length != (p2 = element.getParameters()).length) continue;
            boolean isEqual = true;
            for (int i = 0; i < p2.length; ++i) {
                isEqual &= p1[i].equals(p2[i]);
            }
            if (!(isEqual &= node.getReturnType().equals(element.getReturnType()))) continue;
            this.addError("Repetitive method name/signature in class " + this.currentClass.getName(), node);
        }
    }

    public void visitField(FieldNode node) {
        if (this.currentClass.getField(node.getName()) != node) {
            this.addError("The field " + node.getName() + " is declared multiple times.", node);
        }
        this.checkInterfaceFieldModifiers(node);
        super.visitField(node);
    }

    private void checkInterfaceFieldModifiers(FieldNode node) {
        if (!this.currentClass.isInterface()) {
            return;
        }
        if ((node.getModifiers() & 0x19) == 0) {
            this.addError("The field " + node.getName() + " is not 'public final static' but part of the interface " + this.currentClass.getName() + ".", node);
        }
    }
}

