/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.beans.Introspector;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.util.StringHelper;

public class DefaultReverseEngineeringStrategy
implements ReverseEngineeringStrategy {
    String packageName;

    public String columnToPropertyName(TableIdentifier table, String columnName) {
        return Introspector.decapitalize(this.toUpperCamelCase(columnName));
    }

    protected String toUpperCamelCase(String s) {
        if ("".equals(s)) {
            return s;
        }
        StringBuffer result = new StringBuffer();
        boolean capitalize = true;
        boolean lastCapital = false;
        boolean lastDecapitalized = false;
        String p = null;
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if ("_".equals(c) || " ".equals(c) || "-".equals(c)) {
                capitalize = true;
                continue;
            }
            if (c.toUpperCase().equals(c)) {
                if (lastDecapitalized && !lastCapital) {
                    capitalize = true;
                }
                lastCapital = true;
            } else {
                lastCapital = false;
            }
            if (capitalize) {
                if (p == null || !p.equals("_")) {
                    result.append(c.toUpperCase());
                    capitalize = false;
                    p = c;
                    continue;
                }
                result.append(c.toLowerCase());
                capitalize = false;
                p = c;
                continue;
            }
            result.append(c.toLowerCase());
            lastDecapitalized = true;
            p = c;
        }
        String r = result.toString();
        return r;
    }

    public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, TableIdentifier referencedTable) {
        String singular = Introspector.decapitalize(StringHelper.unqualify((String)this.tableToClassName(fromTable)));
        char last = singular.charAt(singular.length() - 1);
        switch (last) {
            case 's': 
            case 'x': {
                singular = singular + "es";
                break;
            }
            case 'y': {
                singular = singular.substring(0, singular.length() - 1) + "ies";
                break;
            }
            default: {
                singular = singular + "s";
            }
        }
        return singular;
    }

    public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, TableIdentifier referencedTable) {
        return Introspector.decapitalize(StringHelper.unqualify((String)this.tableToClassName(referencedTable)));
    }

    public void setPackageName(String pkg) {
        this.packageName = pkg;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String tableToClassName(TableIdentifier table) {
        if (this.packageName != null && this.packageName.trim().length() > 0) {
            return StringHelper.qualify((String)this.packageName, (String)this.toUpperCamelCase(table.getName()));
        }
        return this.toUpperCamelCase(table.getName());
    }

    public String jdbcToHibernateType(int sqlType, int length, int precision, int scale) {
        return JDBCToHibernateTypeHelper.getPreferredHibernateType(sqlType, length, precision, scale);
    }

    public boolean excludeTable(TableIdentifier ti) {
        return false;
    }
}

