/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;

public class JDBCToHibernateTypeHelper {
    private static final Map preferredHibernateTypeForSqlType = new HashMap();
    static Map jdbcTypes;
    static Map jdbcTypeValues;

    private JDBCToHibernateTypeHelper() {
    }

    public static String getPreferredHibernateType(int sqlType, int size, int precision, int scale) {
        if ((sqlType == 3 || sqlType == 2) && scale == 0) {
            if (precision == 1) {
                return "boolean";
            }
            if (precision < 3) {
                return "byte";
            }
            if (precision < 5) {
                return "short";
            }
            if (precision < 10) {
                return "integer";
            }
            if (precision < 19) {
                return "long";
            }
            return "big_decimal";
        }
        String result = (String)preferredHibernateTypeForSqlType.get(new Integer(sqlType));
        if (result == null) {
            result = "java.lang.Object";
        }
        return result;
    }

    public static int getJDBCType(String value) {
        Integer number;
        if (jdbcTypes == null) {
            jdbcTypes = new HashMap();
            Field[] fields = Types.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    jdbcTypes.put(field.getName(), field.get(class$java$sql$Types == null ? JDBCToHibernateTypeHelper.class$("java.sql.Types") : class$java$sql$Types));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        if ((number = (Integer)jdbcTypes.get(value)) == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                throw new MappingException("jdbc-type: " + value + " is not a known JDBC Type nor a valid number");
            }
        }
        return number;
    }

    public static String getJDBCTypeName(int value) {
        String name;
        if (jdbcTypeValues == null) {
            jdbcTypeValues = new HashMap();
            Field[] fields = Types.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!Modifier.isStatic(field.getModifiers())) continue;
                try {
                    jdbcTypeValues.put(field.get(class$java$sql$Types == null ? JDBCToHibernateTypeHelper.class$("java.sql.Types") : class$java$sql$Types), field.getName());
                    continue;
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        if ((name = (String)jdbcTypeValues.get(new Integer(value))) != null) {
            return name;
        }
        return "" + value;
    }

    static {
        preferredHibernateTypeForSqlType.put(new Integer(-6), "byte");
        preferredHibernateTypeForSqlType.put(new Integer(5), "short");
        preferredHibernateTypeForSqlType.put(new Integer(4), "integer");
        preferredHibernateTypeForSqlType.put(new Integer(-5), "long");
        preferredHibernateTypeForSqlType.put(new Integer(7), "float");
        preferredHibernateTypeForSqlType.put(new Integer(6), "double");
        preferredHibernateTypeForSqlType.put(new Integer(8), "double");
        preferredHibernateTypeForSqlType.put(new Integer(3), "big_decimal");
        preferredHibernateTypeForSqlType.put(new Integer(2), "big_decimal");
        preferredHibernateTypeForSqlType.put(new Integer(-7), "boolean");
        preferredHibernateTypeForSqlType.put(new Integer(1), "character");
        preferredHibernateTypeForSqlType.put(new Integer(12), "string");
        preferredHibernateTypeForSqlType.put(new Integer(-1), "string");
        preferredHibernateTypeForSqlType.put(new Integer(-2), "binary");
        preferredHibernateTypeForSqlType.put(new Integer(-3), "binary");
        preferredHibernateTypeForSqlType.put(new Integer(-4), "binary");
        preferredHibernateTypeForSqlType.put(new Integer(91), "date");
        preferredHibernateTypeForSqlType.put(new Integer(92), "time");
        preferredHibernateTypeForSqlType.put(new Integer(93), "timestamp");
        preferredHibernateTypeForSqlType.put(new Integer(2005), "clob");
        preferredHibernateTypeForSqlType.put(new Integer(2004), "blob");
    }
}

