/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.cfg.reveng.DelegatingReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideBinder;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OverrideRepository {
    private static Log log = LogFactory.getLog((Class)OverrideRepository.class);
    private transient XMLHelper xmlHelper = new XMLHelper();
    private transient EntityResolver entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
    private Map typeMappings = new HashMap();
    private List tableFilters = new ArrayList();

    public OverrideRepository addFile(File xmlFile) {
        log.info((Object)("Override file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure overrides from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException("Could not configure overrides from file: " + xmlFile.getPath(), (Throwable)e);
        }
        return this;
    }

    public OverrideRepository addResource(String path) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            rsrc = OverrideRepository.class.getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, (Throwable)me);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OverrideRepository addInputStream(InputStream xmlInputStream) throws MappingException {
        OverrideRepository overrideRepository;
        try {
            try {
                ArrayList errors = new ArrayList();
                Document doc = this.xmlHelper.createSAXReader("XML InputStream", errors, this.entityResolver).read(new InputSource(xmlInputStream));
                if (errors.size() != 0) {
                    throw new MappingException("invalid override definition", (Throwable)errors.get(0));
                }
                this.add(doc);
                overrideRepository = this;
                Object var6_7 = null;
            }
            catch (MappingException me) {
                throw me;
            }
            catch (Exception e) {
                log.error((Object)"Could not configure overrides from input stream", (Throwable)e);
                throw new MappingException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                xmlInputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                log.error((Object)"could not close input stream", (Throwable)ioe);
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            log.error((Object)"could not close input stream", (Throwable)ioe);
            return overrideRepository;
        }
        xmlInputStream.close();
        return overrideRepository;
    }

    private OverrideRepository add(Document doc) {
        OverrideBinder.bindRoot(this, doc);
        return this;
    }

    private String getPreferredHibernateType(int sqlType, int length, int precision, int scale) {
        List l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, length));
        if (l != null) {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                SQLTypeMapping element = (SQLTypeMapping)iterator.next();
                if (element.getJDBCType() != sqlType) {
                    return null;
                }
                if (!element.match(sqlType, length, precision, scale)) continue;
                return element.getHibernateType();
            }
        }
        return null;
    }

    public OverrideRepository addTypeMapping(SQLTypeMapping sqltype) {
        TypeMappingKey key = new TypeMappingKey(sqltype);
        ArrayList<SQLTypeMapping> list = (ArrayList<SQLTypeMapping>)this.typeMappings.get(key);
        if (list == null) {
            list = new ArrayList<SQLTypeMapping>();
            this.typeMappings.put(key, list);
        }
        list.add(sqltype);
        return this;
    }

    protected boolean excludeTable(TableIdentifier identifier) {
        Iterator iterator = this.tableFilters.iterator();
        while (iterator.hasNext()) {
            TableFilter tf = (TableFilter)iterator.next();
            Boolean value = tf.exclude(identifier);
            if (value == null) continue;
            return value;
        }
        return false;
    }

    public void addTableFilter(TableFilter filter) {
        this.tableFilters.add(filter);
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy(ReverseEngineeringStrategy delegate) {
        return new DelegatingReverseEngineeringStrategy(delegate){

            public boolean excludeTable(TableIdentifier ti) {
                return OverrideRepository.this.excludeTable(ti);
            }

            public String jdbcToHibernateType(int sqlType, int length, int precision, int scale) {
                String result = OverrideRepository.this.getPreferredHibernateType(sqlType, length, precision, scale);
                if (result == null) {
                    return super.jdbcToHibernateType(sqlType, length, precision, scale);
                }
                return result;
            }
        };
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.getReverseEngineeringStrategy(null);
    }

    static class TypeMappingKey {
        int type;
        int length;

        TypeMappingKey(SQLTypeMapping mpa) {
            this.type = mpa.getJDBCType();
            this.length = mpa.getLength();
        }

        public TypeMappingKey(int sqlType, int length) {
            this.type = sqlType;
            this.length = length;
        }

        public boolean equals(Object obj) {
            TypeMappingKey other = (TypeMappingKey)obj;
            if (obj == null) {
                return false;
            }
            return this.type == other.type && this.length == other.length;
        }

        public int hashCode() {
            return (this.type + this.length) % 17;
        }
    }
}

