/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import org.hibernate.mapping.Table;

public class TableIdentifier {
    private final String catalog;
    private final String schema;
    private final String name;

    public TableIdentifier(String name) {
        this(null, null, name);
    }

    public TableIdentifier(String catalog, String schema, String name) {
        this.catalog = catalog == null ? null : catalog.intern();
        this.schema = schema == null ? null : schema.intern();
        this.name = name == null ? null : name.intern();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean equals(Object obj) {
        return obj instanceof TableIdentifier && this.equals((TableIdentifier)obj);
    }

    public boolean equals(TableIdentifier otherIdentifier) {
        if (otherIdentifier == null) {
            return false;
        }
        if (this == otherIdentifier) {
            return true;
        }
        if (this.equals(this.name, otherIdentifier.name) && this.equals(this.schema, otherIdentifier.schema)) {
            return this.equals(this.catalog, otherIdentifier.catalog);
        }
        return false;
    }

    private boolean equals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public static TableIdentifier create(Table table) {
        return new TableIdentifier(table.getCatalog(), table.getSchema(), table.getName());
    }
}

