/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.HibernateUberspect;
import org.hibernate.tool.hbm2x.RenderTool;

public class TemplateHelper {
    private VelocityContext context;
    private VelocityEngine engine;
    private Cfg2JavaTool c2j = new Cfg2JavaTool();
    private Cfg2HbmTool c2h = new Cfg2HbmTool();

    public void init(String[] templatePaths) {
        this.context = new VelocityContext();
        this.engine = new VelocityEngine();
        Properties p = new Properties();
        p.setProperty("runtime.log.logsystem.class", "org.apache.velocity.tools.generic.log.CommonsLogLogSystem");
        p.setProperty("runtime.log.logsystem.commons.logging.name", "org.hibernate.tool.hbm2x.template");
        p.setProperty("runtime.introspector.uberspect", HibernateUberspect.class.getName());
        p.setProperty("resource.loader", "file, class");
        p.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
        p.setProperty("velocimacro.library", "");
        if (templatePaths != null && templatePaths.length > 0) {
            StringBuffer cvspath = new StringBuffer();
            for (int i = 0; i < templatePaths.length; ++i) {
                String path = templatePaths[i];
                if (i > 0) {
                    cvspath.append(",");
                }
                cvspath.append(path);
            }
            p.setProperty("file.resource.loader.path", cvspath.toString());
        }
        try {
            this.engine.init(p);
        }
        catch (Exception e) {
            throw new ExporterException("Velocity engine could not be initialized", e);
        }
        this.getContext().put("ctx", (Object)this.getContext());
        this.getContext().put("c2j", (Object)this.c2j);
        this.getContext().put("c2h", (Object)this.c2h);
        this.getContext().put("render", (Object)new RenderTool(this.getEngine()));
    }

    public void processTemplate(String templateName, Writer output) {
        try {
            this.getEngine().mergeTemplate(templateName, this.getContext(), output);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
        catch (ResourceNotFoundException e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
        catch (ParseErrorException e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
        catch (MethodInvocationException e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing template " + templateName, e);
        }
    }

    public void processString(String template, Writer output) {
        try {
            this.getEngine().evaluate(this.getContext(), output, "TemplateHelper", template);
        }
        catch (IOException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (ResourceNotFoundException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (ParseErrorException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (MethodInvocationException e) {
            throw new ExporterException("Error while processing template string", e);
        }
        catch (Exception e) {
            throw new ExporterException("Error while processing template string", e);
        }
    }

    protected Context getContext() {
        return this.context;
    }

    protected VelocityEngine getEngine() {
        return this.engine;
    }

    public void putInContext(String key, Object value) {
        if (value == null) {
            throw new IllegalStateException("value must not be null for " + key);
        }
        Object replaced = this.getContext().put(key, value);
        if (replaced != null) {
            throw new IllegalStateException(replaced + " found when setting " + key);
        }
    }

    public void removeFromContext(String key, Object expected) {
        Object replaced = this.getContext().remove((Object)key);
        if (replaced == null) {
            throw new IllegalStateException(key + " had nothing.");
        }
        if (replaced != expected) {
            throw new IllegalStateException("expected " + key + " to be bound to " + expected + " but was to " + replaced);
        }
    }

    public Cfg2JavaTool getCfg2JavaTool() {
        return this.c2j;
    }

    public Cfg2HbmTool getCfg2HbmTool() {
        return this.c2h;
    }

    public boolean templateExists(String templateName) {
        return this.getEngine().templateExists(templateName);
    }
}

