/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public final class DocHelper {
    public static final String DEFAULT_NO_SCHEMA_NAME = "default";
    private Configuration cfg;
    private Map tablesBySchema = new HashMap();
    private Map valuesByColumn = new HashMap();
    private Map propsByValue = new HashMap();
    private List tables = new ArrayList();
    private Map tableSchemaNames = new HashMap();
    private Dialect dialect;

    public DocHelper(Configuration cfg) {
        if (cfg == null) {
            throw new IllegalArgumentException("Hibernate Configuration cannot be null");
        }
        this.cfg = cfg;
        this.dialect = Dialect.getDialect((Properties)cfg.getProperties());
        Settings settings = cfg.buildSettings();
        String defaultCatalog = settings.getDefaultCatalogName();
        String defaultSchema = settings.getDefaultSchemaName();
        if (defaultSchema == null) {
            defaultSchema = DEFAULT_NO_SCHEMA_NAME;
        }
        Iterator tablesIter = cfg.getTableMappings();
        while (tablesIter.hasNext()) {
            String schema;
            Table table = (Table)tablesIter.next();
            this.tables.add(table);
            StringBuffer sb = new StringBuffer();
            String catalog = table.getCatalog();
            if (catalog == null) {
                catalog = defaultCatalog;
            }
            if (catalog != null) {
                sb.append(catalog + ".");
            }
            if ((schema = table.getSchema()) == null) {
                schema = defaultSchema;
            }
            sb.append(schema);
            String qualSchemaName = sb.toString();
            this.tableSchemaNames.put(table, qualSchemaName);
            ArrayList<Table> tableList = (ArrayList<Table>)this.tablesBySchema.get(qualSchemaName);
            if (tableList == null) {
                tableList = new ArrayList<Table>();
                this.tablesBySchema.put(qualSchemaName, tableList);
            }
            tableList.add(table);
            Iterator columns = table.getColumnIterator();
            while (columns.hasNext()) {
                Column column = (Column)columns.next();
                String columnFQN = this.getQualifiedColumnName(table, column);
                ArrayList<Value> values = (ArrayList<Value>)this.valuesByColumn.get(columnFQN);
                if (values == null) {
                    values = new ArrayList<Value>();
                    this.valuesByColumn.put(columnFQN, values);
                }
                values.add(column.getValue());
            }
        }
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            Iterator properties = clazz.getPropertyIterator();
            while (properties.hasNext()) {
                Property property = (Property)properties.next();
                Value value = property.getValue();
                ArrayList<Property> props = (ArrayList<Property>)this.propsByValue.get(value);
                if (props == null) {
                    props = new ArrayList<Property>();
                    this.propsByValue.put(value, props);
                }
                props.add(property);
            }
        }
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public Map getTablesBySchema() {
        return this.tablesBySchema;
    }

    public List getSchemas() {
        ArrayList schemas = new ArrayList(this.tablesBySchema.keySet());
        Collections.sort(schemas);
        return schemas;
    }

    public List getTables(String schema) {
        return (List)this.tablesBySchema.get(schema);
    }

    public List getTables() {
        return this.tables;
    }

    public String getQualifiedSchemaName(Table table) {
        return (String)this.tableSchemaNames.get(table);
    }

    public String getQualifiedTableName(Table table) {
        String qualifiedSchemaName = this.getQualifiedSchemaName(table);
        return qualifiedSchemaName + '.' + table.getName();
    }

    public String getQualifiedColumnName(Table table, Column column) {
        String qualifiedTableName = this.getQualifiedTableName(table);
        return qualifiedTableName + '.' + column.getName();
    }

    public String getSQLTypeName(Column column) {
        try {
            return column.getSqlType(this.dialect, null);
        }
        catch (Exception ex) {
            return "N/D";
        }
    }

    public List getValues(Table table, Column column) {
        String columnFQN = this.getQualifiedColumnName(table, column);
        List values = (List)this.valuesByColumn.get(columnFQN);
        if (values != null) {
            return values;
        }
        return new ArrayList();
    }

    public List getProperties(Table table, Column column) {
        ArrayList result = new ArrayList();
        Iterator values = this.getValues(table, column).iterator();
        while (values.hasNext()) {
            Value value = (Value)values.next();
            List props = (List)this.propsByValue.get(value);
            if (props == null) continue;
            result.addAll(props);
        }
        return result;
    }
}

