/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx;

import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.store.IArtifactStore;
import io.apisense.embed.influx.EmbeddedDB;
import io.apisense.embed.influx.ServerAlreadyRunningException;
import io.apisense.embed.influx.ServerNotRunningException;
import io.apisense.embed.influx.ServerState;
import io.apisense.embed.influx.configuration.ConfigurationWriter;
import io.apisense.embed.influx.configuration.InfluxVersion;
import io.apisense.embed.influx.configuration.VersionConfiguration;
import io.apisense.embed.influx.configuration.embed.InfluxArtifactStoreBuilder;
import io.apisense.embed.influx.configuration.embed.InfluxDownloadConfigBuilder;
import io.apisense.embed.influx.configuration.embed.InfluxExecutableConfig;
import io.apisense.embed.influx.configuration.embed.InfluxRuntimeConfigBuilder;
import io.apisense.embed.influx.execution.InfluxExecutor;
import io.apisense.embed.influx.execution.embed.InfluxServerStarter;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxServer
implements EmbeddedDB {
    private static final Logger logger = LoggerFactory.getLogger((String)InfluxServer.class.getName());
    private ServerState currentState = ServerState.UNKNOWN;
    private final InfluxExecutor executor;

    private InfluxServer(InfluxServerStarter influxServerStarter, InfluxExecutableConfig executableConfig, Distribution versionConfiguration) {
        this(new InfluxExecutor(influxServerStarter, executableConfig, versionConfiguration));
    }

    InfluxServer(InfluxExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void init() throws ServerAlreadyRunningException {
        if (this.currentState == ServerState.STARTED) {
            throw new ServerAlreadyRunningException(this);
        }
        logger.info("Initializing server: " + this.toString());
        this.executor.prepare();
        this.currentState = ServerState.READY;
    }

    @Override
    public void start() throws ServerAlreadyRunningException {
        if (this.currentState == ServerState.STARTED) {
            throw new ServerAlreadyRunningException(this);
        }
        if (this.currentState != ServerState.READY && this.currentState != ServerState.STOPPED) {
            this.init();
        }
        logger.info("Starting server: " + this.toString());
        try {
            this.executor.start();
        }
        catch (IOException e) {
            logger.error("Unable to start server: " + e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        this.currentState = ServerState.STARTED;
    }

    @Override
    public void stop() throws ServerNotRunningException {
        if (this.currentState != ServerState.STARTED) {
            throw new ServerNotRunningException(this);
        }
        logger.info("Stopping server: " + this.toString());
        this.executor.stop();
        this.currentState = ServerState.STOPPED;
    }

    @Override
    public void cleanup() throws ServerNotRunningException {
        if (this.currentState != ServerState.STOPPED) {
            this.stop();
        }
        logger.info("Removing data for server: " + this.toString());
        this.executor.cleanup();
        this.currentState = ServerState.CLEAN;
    }

    public static class Builder {
        private ConfigurationWriter configurationWriter;
        private VersionConfiguration versionConfig;
        private File storePath;
        private File extractionPath;

        public InfluxServer build() throws IOException {
            if (this.versionConfig == null) {
                this.setVersionConfig(VersionConfiguration.fromRuntime(InfluxVersion.PRODUCTION));
            }
            IRuntimeConfig runtimeConfig = this.buildRuntimeConfig();
            InfluxServerStarter influxServerStarter = new InfluxServerStarter(runtimeConfig);
            InfluxExecutableConfig executionConfig = new InfluxExecutableConfig(this.versionConfig.version, this.configurationWriter);
            return new InfluxServer(influxServerStarter, executionConfig, this.versionConfig);
        }

        private IRuntimeConfig buildRuntimeConfig() {
            IDownloadConfig downloadConfig = new InfluxDownloadConfigBuilder(this.storePath).getConfig();
            IArtifactStore store = new InfluxArtifactStoreBuilder(downloadConfig, this.extractionPath).getConfig();
            return new InfluxRuntimeConfigBuilder(store).getConfig();
        }

        public Builder setVersionConfig(VersionConfiguration versionConfig) {
            this.versionConfig = versionConfig;
            return this;
        }

        public Builder setStorePath(File storePath) throws IOException {
            if (!storePath.isDirectory()) {
                throw new IOException("Not a directory: " + storePath.getAbsolutePath());
            }
            this.storePath = storePath;
            return this;
        }

        public Builder setExtractionPath(File extractionPath) throws IOException {
            if (!extractionPath.isDirectory()) {
                throw new IOException("Not a directory: " + extractionPath.getAbsolutePath());
            }
            this.extractionPath = extractionPath;
            return this;
        }

        public Builder setInfluxConfiguration(ConfigurationWriter configurationWriter) {
            this.configurationWriter = configurationWriter;
            return this;
        }
    }
}

