/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx.configuration;

import com.moandjiezana.toml.TomlWriter;
import io.apisense.embed.influx.configuration.ConfigurationWriter;
import io.apisense.embed.influx.configuration.server.ConfigurationProperty;
import io.apisense.embed.influx.configuration.server.ConfigurationSection;
import io.apisense.embed.influx.configuration.server.DataConfigurationSection;
import io.apisense.embed.influx.configuration.server.HeadConfigurationSection;
import io.apisense.embed.influx.configuration.server.HttpConfigurationSection;
import io.apisense.embed.influx.configuration.server.MetaConfigurationSection;
import io.apisense.embed.influx.configuration.server.UdpConfigurationSection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxConfigurationWriter
implements ConfigurationWriter {
    private static final Logger logger = LoggerFactory.getLogger((String)InfluxConfigurationWriter.class.getName());
    private final Map<String, Object> configMap;
    private final TomlWriter tomlWriter;
    private File dataPath;

    InfluxConfigurationWriter(Set<ConfigurationSection> configurationSections, File dataPath, TomlWriter writer) {
        this.dataPath = dataPath;
        this.tomlWriter = writer;
        this.configMap = InfluxConfigurationWriter.inflateConfigurationMap(configurationSections);
    }

    private static Map<String, Object> inflateConfigurationMap(Set<ConfigurationSection> configurationSections) {
        LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
        for (ConfigurationSection configurationSection : configurationSections) {
            if (configurationSection.getName() != null) continue;
            InfluxConfigurationWriter.addConfigProperties(configurationSection, configMap);
        }
        for (ConfigurationSection configurationSection : configurationSections) {
            if (configurationSection.getName() == null) continue;
            if (configurationSection.isArray().booleanValue()) {
                configMap.put(configurationSection.getName(), Collections.singletonList(configurationSection.getConfiguration()));
                continue;
            }
            configMap.put(configurationSection.getName(), configurationSection.getConfiguration());
        }
        return configMap;
    }

    private static void addConfigProperties(ConfigurationSection configurationSection, Map<String, Object> configMap) {
        Map<ConfigurationProperty, Object> configuration = configurationSection.getConfiguration();
        for (ConfigurationProperty configurationProperty : configuration.keySet()) {
            configMap.put(configurationProperty.toString(), configuration.get((Object)configurationProperty));
        }
    }

    @Override
    public File getDataPath() {
        return this.dataPath;
    }

    @Override
    public void addStatements(Map<String, Object> config) {
        this.configMap.putAll(config);
    }

    @Override
    public File writeFile() throws IOException {
        File configFile = File.createTempFile("influxdb.config", Long.toString(System.nanoTime()));
        logger.debug("Writing configuration file into: " + configFile.getAbsolutePath());
        this.tomlWriter.write(this.configMap, configFile);
        return configFile;
    }

    public static final class Builder {
        private Set<ConfigurationSection> configuration;
        private TomlWriter writer = new TomlWriter();
        private File dataPath = null;

        public Builder() {
            this.configuration = new LinkedHashSet<ConfigurationSection>();
            this.setBackupAndRestorePort(8088);
            this.setHttp(8086);
        }

        public InfluxConfigurationWriter build() {
            if (this.dataPath == null) {
                try {
                    File tempFile = Files.createTempDirectory("embed-influx-data-" + Long.toString(System.nanoTime()), new FileAttribute[0]).toFile();
                    this.setDataPath(tempFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to create default data path", e);
                }
            }
            return new InfluxConfigurationWriter(this.configuration, this.dataPath, this.writer);
        }

        public Builder setHttp(int httpPort) {
            this.addSection(new HttpConfigurationSection(httpPort, false));
            return this;
        }

        public Builder setHttp(int httpPort, boolean auth) {
            this.addSection(new HttpConfigurationSection(httpPort, auth));
            return this;
        }

        public Builder setBackupAndRestorePort(int backupAndRestorePort) {
            this.addSection(new HeadConfigurationSection(backupAndRestorePort));
            return this;
        }

        public Builder setUdp(int udpPort) {
            this.addSection(new UdpConfigurationSection(udpPort, "udp"));
            return this;
        }

        public Builder setUdp(int udpPort, String database) {
            this.addSection(new UdpConfigurationSection(udpPort, database));
            return this;
        }

        public Builder setDataPath(File dataPath) {
            this.dataPath = dataPath;
            this.addSection(new MetaConfigurationSection(dataPath));
            this.addSection(new DataConfigurationSection(dataPath));
            return this;
        }

        public Builder addSection(ConfigurationSection section) {
            this.configuration.remove(section);
            this.configuration.add(section);
            return this;
        }

        public Builder setWriter(TomlWriter writer) {
            this.writer = writer;
            return this;
        }
    }
}

