/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx.configuration;

import de.flapdoodle.embed.process.distribution.BitSize;

public enum OSArchitecture {
    i386("i386", BitSize.B32),
    x86_64("amd64", BitSize.B64),
    ARM("armhf", BitSize.B32);

    public final String dlPath;
    public final BitSize bitSize;

    private OSArchitecture(String dlPath, BitSize bitSize) {
        this.dlPath = dlPath;
        this.bitSize = bitSize;
    }

    public static OSArchitecture getCurrent() {
        String arch = System.getProperty("os.arch");
        if (arch.contains("64")) {
            return x86_64;
        }
        if (arch.contains("32")) {
            return i386;
        }
        if (arch.contains("arm")) {
            return ARM;
        }
        throw new IllegalArgumentException("Unable to find architecture: " + arch);
    }

    public BitSize toBitSize() {
        return this.bitSize;
    }
}

