/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx.configuration;

import de.flapdoodle.embed.process.distribution.Platform;
import io.apisense.embed.influx.download.InfluxArchiveType;

public enum OSType {
    Linux("linux", InfluxArchiveType.TGZ, Platform.Linux),
    Windows("windows", InfluxArchiveType.ZIP, Platform.Windows),
    Mac("darwin", InfluxArchiveType.TGZ, Platform.OS_X);

    public final String dlPath;
    public final InfluxArchiveType archiveType;
    private Platform platform;

    private OSType(String dlPath, InfluxArchiveType archiveType, Platform platform) {
        this.dlPath = dlPath;
        this.archiveType = archiveType;
        this.platform = platform;
    }

    public static OSType getCurrent() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            return Windows;
        }
        if (os.contains("mac")) {
            return Mac;
        }
        return Linux;
    }

    public Platform toPlatform() {
        return this.platform;
    }
}

