/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx.configuration.embed;

import de.flapdoodle.embed.process.config.store.DownloadConfigBuilder;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.FixedPath;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.UserHome;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import io.apisense.embed.influx.download.embed.PackageResolver;
import java.io.File;

public class InfluxDownloadConfigBuilder {
    private static final String DEFAULT_PATH = ".embedded-influx";
    public final DownloadConfigBuilder builder;

    public InfluxDownloadConfigBuilder(File storePath) {
        this((IDirectory)(storePath != null ? new FixedPath(storePath.getAbsolutePath()) : new UserHome(DEFAULT_PATH)));
    }

    private InfluxDownloadConfigBuilder(IDirectory storePath) {
        this.builder = InfluxDownloadConfigBuilder.downloadConfigBuilder(storePath);
    }

    private static DownloadConfigBuilder downloadConfigBuilder(IDirectory storePath) {
        return new DownloadConfigBuilder().artifactStorePath(storePath).fileNaming((ITempNaming)new UUIDTempNaming()).downloadPath("https://dl.influxdata.com").progressListener((IProgressListener)new StandardConsoleProgressListener()).downloadPrefix("embedded-influx-download").packageResolver((IPackageResolver)new PackageResolver()).userAgent("Mozilla/5.0 (compatible; Embedded Influx; +https://github.com/APISENSE/embed-influxDB)");
    }

    public IDownloadConfig getConfig() {
        return this.builder.build();
    }
}

