/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx.execution;

import de.flapdoodle.embed.process.distribution.Distribution;
import io.apisense.embed.influx.configuration.embed.InfluxExecutableConfig;
import io.apisense.embed.influx.execution.EmbeddedExecutor;
import io.apisense.embed.influx.execution.embed.InfluxExecutable;
import io.apisense.embed.influx.execution.embed.InfluxProcess;
import io.apisense.embed.influx.execution.embed.InfluxServerStarter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxExecutor
implements EmbeddedExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)InfluxExecutor.class.getName());
    private InfluxExecutable preparedExecution;
    private final InfluxServerStarter serverStarter;
    private final InfluxExecutableConfig executableConfig;
    private final Distribution versionConfiguration;
    private InfluxProcess influxProcess;

    public InfluxExecutor(InfluxServerStarter starter, InfluxExecutableConfig executableConfig, Distribution versionConfiguration) {
        this.serverStarter = starter;
        this.executableConfig = executableConfig;
        this.versionConfiguration = versionConfiguration;
    }

    @Override
    public synchronized void prepare() {
        if (this.preparedExecution == null) {
            this.preparedExecution = (InfluxExecutable)this.serverStarter.prepare(this.executableConfig, this.versionConfiguration);
        }
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.preparedExecution != null && this.influxProcess == null) {
            this.influxProcess = (InfluxProcess)this.preparedExecution.start();
            logger.debug("Process started (id n\u00b0" + this.influxProcess.getProcessId() + ")");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.influxProcess != null) {
            logger.debug("Stopping process (id n\u00b0" + this.influxProcess.getProcessId() + ")");
            this.influxProcess.stop();
            this.influxProcess = null;
        }
    }

    @Override
    public synchronized void cleanup() {
        if (this.preparedExecution != null) {
            this.preparedExecution.stop();
            this.preparedExecution = null;
        }
    }
}

