/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.embed.influx.execution.embed;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import io.apisense.embed.influx.configuration.embed.InfluxExecutableConfig;
import io.apisense.embed.influx.execution.embed.InfluxExecutable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxProcess
extends AbstractProcess<InfluxExecutableConfig, InfluxExecutable, InfluxProcess> {
    private static final Logger logger = LoggerFactory.getLogger((String)InfluxProcess.class.getName());
    private File configFile;
    private File dataPath;

    InfluxProcess(Distribution distribution, InfluxExecutableConfig config, IRuntimeConfig runtimeConfig, InfluxExecutable executable) throws IOException {
        super(distribution, (IExecutableProcessConfig)config, runtimeConfig, (Executable)executable);
    }

    protected List<String> getCommandLine(Distribution distribution, InfluxExecutableConfig config, IExtractedFileSet exe) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(Files.fileOf((File)exe.baseDir(), (File)exe.executable()).getAbsolutePath());
        commands.add("run");
        if (config.configurationWriter() != null) {
            this.dataPath = config.configurationWriter().getDataPath();
            this.configFile = config.configurationWriter().writeFile();
            logger.debug("Using config file " + this.configFile.getAbsolutePath());
            commands.add("-config=" + this.configFile.getAbsolutePath());
        }
        return commands;
    }

    protected void stopInternal() {
        this.setProcessId(this.getProcessId());
        if (!this.sendTermToProcess()) {
            logger.warn("SIGTERM not working, trying SIGINT (id n\u00b0" + this.getProcessId() + ")");
            if (!this.sendKillToProcess()) {
                logger.warn("SIGINT not working! trying Windows kill (?) (id n\u00b0" + this.getProcessId() + ")");
                if (!this.tryKillToProcess()) {
                    logger.warn("Unable to close process (id n\u00b0" + this.getProcessId() + ")");
                }
            }
        }
        this.stopProcess();
    }

    protected void cleanupInternal() {
        if (this.configFile != null) {
            if (!this.configFile.delete()) {
                logger.warn("Unable to remove log file: " + this.configFile.getAbsolutePath());
            }
            this.configFile = null;
        }
        if (this.dataPath != null && !Files.forceDelete((File)this.dataPath)) {
            logger.warn("Unable to remove data dir: " + this.configFile.getAbsolutePath());
        }
    }
}

