/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sqs.support.resolver;

import io.awspring.cloud.sqs.MessageHeaderUtils;
import io.awspring.cloud.sqs.listener.acknowledgement.AcknowledgementCallback;
import io.awspring.cloud.sqs.listener.acknowledgement.BatchAcknowledgement;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BatchAcknowledgmentArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable(BatchAcknowledgement.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) {
        Object payloadObject = message.getPayload();
        Assert.isInstanceOf(Collection.class, (Object)payloadObject, (String)"Payload must be instance of Collection");
        Collection messages = (Collection)payloadObject;
        AcknowledgementCallback callback = (AcknowledgementCallback)((Message)messages.iterator().next()).getHeaders().get((Object)"AcknowledgementCallback", AcknowledgementCallback.class);
        Assert.notNull((Object)callback, (String)("No acknowledgement found for messages " + MessageHeaderUtils.getId(messages) + ". AcknowledgeMode should be MANUAL."));
        return this.createBatchAcknowledgement(messages, callback);
    }

    private <T> BatchAcknowledgement<T> createBatchAcknowledgement(final Collection<Message<T>> messages, final AcknowledgementCallback<T> callback) {
        return new BatchAcknowledgement<T>(){

            @Override
            public void acknowledge() {
                this.acknowledgeAsync().join();
            }

            @Override
            public CompletableFuture<Void> acknowledgeAsync() {
                return callback.onAcknowledge(messages);
            }

            @Override
            public void acknowledge(Collection<Message<T>> messagesToAcknowledge) {
                this.acknowledgeAsync(messagesToAcknowledge).join();
            }

            @Override
            public CompletableFuture<Void> acknowledgeAsync(Collection<Message<T>> messagesToAcknowledge) {
                return callback.onAcknowledge(messagesToAcknowledge);
            }
        };
    }
}

