/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp;

import io.ballerina.messaging.broker.amqp.AckData;
import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicDeliver;
import io.ballerina.messaging.broker.amqp.codec.frames.ContentFrame;
import io.ballerina.messaging.broker.amqp.codec.frames.HeaderFrame;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.util.MessageTracer;
import io.ballerina.messaging.broker.core.util.TraceField;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpDeliverMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpDeliverMessage.class);
    private static final String SEND_MESSAGE = "Delivering message to client from AMQP transport.";
    private static final String SENT_ON_HOLD = "Message delivery on hold. Flow disabled.";
    private static final String QUEUE_NAME_FIELD = "queueName";
    private static final String CONSUMER_ADDRESS_FIELD = "consumerAddress";
    private final ShortString consumerTag;
    private final AmqpChannel channel;
    private final Message message;
    private final String queueName;
    private final Broker broker;

    public AmqpDeliverMessage(Message message, ShortString consumerTag, AmqpChannel channel, String queueName, Broker broker) {
        this.message = message;
        this.consumerTag = consumerTag;
        this.channel = channel;
        this.queueName = queueName;
        this.broker = broker;
    }

    public void write(ChannelHandlerContext ctx) {
        if (this.channel.isClosed()) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Requeueing message since subscriber is already closed. {}", (Object)this.message);
                }
                this.broker.requeue(this.queueName, this.message);
            }
            catch (BrokerException e) {
                LOGGER.error("Error while requeueing message {} for queue {}", new Object[]{this.message, this.queueName, e});
            }
        } else if (!this.channel.isFlowEnabled()) {
            this.channel.hold(this);
            if (MessageTracer.isTraceEnabled()) {
                MessageTracer.trace((Message)this.message, (String)SENT_ON_HOLD, (TraceField[])new TraceField[]{new TraceField("consumerTag", (Object)this.consumerTag), new TraceField("channelId", (Object)this.channel.getChannelId()), new TraceField(QUEUE_NAME_FIELD, (Object)this.queueName), new TraceField(CONSUMER_ADDRESS_FIELD, (Object)ctx.channel().remoteAddress())});
            }
        } else {
            long deliveryTag = this.channel.getNextDeliveryTag();
            this.channel.recordMessageDelivery(deliveryTag, new AckData(this.message.shallowCopy(), this.queueName, this.consumerTag));
            Metadata metadata = this.message.getMetadata();
            BasicDeliver basicDeliverFrame = new BasicDeliver(this.channel.getChannelId(), this.consumerTag, deliveryTag, this.message.isRedelivered(), ShortString.parseString((String)metadata.getExchangeName()), ShortString.parseString((String)metadata.getRoutingKey()));
            HeaderFrame headerFrame = new HeaderFrame(this.channel.getChannelId(), 60, metadata.getContentLength());
            headerFrame.setProperties(metadata.getProperties());
            headerFrame.setHeaders(metadata.getHeaders());
            ctx.write((Object)basicDeliverFrame);
            ctx.write((Object)headerFrame);
            for (ContentChunk chunk : this.message.getContentChunks()) {
                ContentFrame contentFrame = new ContentFrame(this.channel.getChannelId(), chunk.getBytes().capacity(), chunk.getBytes());
                ctx.write((Object)contentFrame);
            }
            if (MessageTracer.isTraceEnabled()) {
                MessageTracer.trace((Message)this.message, (String)SEND_MESSAGE, (TraceField[])new TraceField[]{new TraceField("deliveryTag", (Object)deliveryTag), new TraceField("channelId", (Object)this.channel.getChannelId()), new TraceField(QUEUE_NAME_FIELD, (Object)this.queueName), new TraceField("consumerTag", (Object)this.consumerTag), new TraceField(CONSUMER_ADDRESS_FIELD, (Object)ctx.channel().remoteAddress())});
            }
        }
    }
}

