/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp;

import io.ballerina.messaging.broker.amqp.AmqpServerConfiguration;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;

public class SslHandlerFactory {
    private SSLContext sslContext;

    public SslHandlerFactory(AmqpServerConfiguration configuration) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = this.getKeyStore(configuration.getSsl().getKeyStore().getType(), configuration.getSsl().getKeyStore().getLocation(), configuration.getSsl().getKeyStore().getPassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(configuration.getSsl().getKeyStore().getCertType());
        keyManagerFactory.init(keyStore, configuration.getSsl().getKeyStore().getPassword().toCharArray());
        KeyStore trustStore = this.getKeyStore(configuration.getSsl().getTrustStore().getType(), configuration.getSsl().getTrustStore().getLocation(), configuration.getSsl().getTrustStore().getPassword());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(configuration.getSsl().getTrustStore().getCertType());
        trustManagerFactory.init(trustStore);
        this.sslContext = SSLContext.getInstance(configuration.getSsl().getProtocol());
        this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(String type, String storePath, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(type);
        try (InputStream in = null;){
            Path path = this.getPath(storePath);
            in = Files.newInputStream(path, new OpenOption[0]);
            keyStore.load(in, password.toCharArray());
        }
        return keyStore;
    }

    private Path getPath(String storePath) {
        Path path = Paths.get(storePath, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            String brokerHome = System.getProperty("message.broker.home");
            path = Paths.get(brokerHome + File.separator + storePath, new String[0]);
        }
        return path;
    }

    public ChannelHandler create() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        return new SslHandler(sslEngine);
    }
}

