/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec;

import io.ballerina.messaging.broker.amqp.AmqpException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.ContentChunk;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import io.ballerina.messaging.broker.core.util.MessageTracer;
import io.ballerina.messaging.broker.core.util.TraceField;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Objects;

public class InMemoryMessageAggregator {
    private static final String CORRELATION_ID_FIELD_NAME = "correlationId";
    private static final String INCOMING_MESSAGE_MAPPED = "Incoming message to AMQP transport.";
    private static final String PUBLISH_MESSAGE = "Publishing message from AMQP transport.";
    private Message message;
    private final Broker broker;
    private BrokerTransaction transaction;
    private String routingKey;
    private String exchangeName;
    private long receivedPayloadSize;

    InMemoryMessageAggregator(Broker broker, BrokerTransaction transaction) {
        this.broker = broker;
        this.transaction = transaction;
    }

    public void basicPublishReceived(ShortString routingKey, ShortString exchangeName) {
        this.routingKey = routingKey.toString();
        this.exchangeName = exchangeName.toString();
    }

    public void headerFrameReceived(FieldTable headers, FieldTable properties, long payloadSize) {
        long messageId = this.broker.getNextMessageId();
        Metadata metadata = new Metadata(this.routingKey, this.exchangeName, payloadSize);
        metadata.setProperties(properties);
        metadata.setHeaders(headers);
        this.message = new Message(messageId, metadata);
        this.trace(this.message);
    }

    private void trace(Message message) {
        if (MessageTracer.isTraceEnabled()) {
            ArrayList<TraceField> traceFields = new ArrayList<TraceField>();
            FieldValue fieldValue = message.getMetadata().getProperty(Metadata.CORRELATION_ID);
            if (Objects.nonNull(fieldValue)) {
                TraceField field = new TraceField(CORRELATION_ID_FIELD_NAME, (Object)fieldValue.getValue());
                traceFields.add(field);
            }
            MessageTracer.trace((Message)message, (String)INCOMING_MESSAGE_MAPPED, traceFields);
        }
    }

    private void clear() {
        this.message = null;
        this.routingKey = null;
        this.exchangeName = null;
        this.receivedPayloadSize = 0L;
    }

    public void publish(Message message) throws BrokerException {
        if (MessageTracer.isTraceEnabled()) {
            MessageTracer.trace((Message)message, (String)PUBLISH_MESSAGE);
        }
        this.transaction.enqueue(message);
    }

    public boolean contentBodyReceived(long length, ByteBuf payload) throws AmqpException {
        ContentChunk contentChunk = new ContentChunk(this.receivedPayloadSize, payload);
        this.message.addChunk(contentChunk);
        this.receivedPayloadSize += length;
        long contentLength = this.message.getMetadata().getContentLength();
        if (contentLength == this.receivedPayloadSize) {
            return true;
        }
        if (contentLength < this.receivedPayloadSize) {
            this.clear();
            this.message.release();
            throw new AmqpException("Content length mismatch. Received content more than the expected size");
        }
        return false;
    }

    public Message popMessage() {
        Message message = this.message;
        this.clear();
        return message;
    }

    public void setTransaction(BrokerTransaction transaction) {
        this.transaction = transaction;
    }
}

