/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.auth;

import io.ballerina.messaging.broker.amqp.codec.auth.AuthenticationStrategy;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionSecure;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionTune;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.auth.AuthManager;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.BrokerException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class SaslAuthenticationStrategy
implements AuthenticationStrategy {
    private AuthManager authManager;
    public static final String SASL_SERVER_ATTRIBUTE = "broker.sasl.server";

    SaslAuthenticationStrategy(AuthManager authManager) {
        this.authManager = authManager;
    }

    @Override
    public void handle(int channel, ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler, ShortString mechanism, LongString response) throws BrokerException {
        try {
            SaslServer saslServer = this.authManager.createSaslServer(connectionHandler.getConfiguration().getHostName(), mechanism.toString());
            byte[] challenge = saslServer.evaluateResponse(response.getBytes());
            if (saslServer.isComplete()) {
                ctx.writeAndFlush((Object)new ConnectionTune(256, 65535L, 0));
            } else {
                ctx.channel().attr(AttributeKey.valueOf((String)SASL_SERVER_ATTRIBUTE)).set((Object)saslServer);
                ctx.writeAndFlush((Object)new ConnectionSecure(channel, LongString.parse((byte[])challenge)));
            }
        }
        catch (SaslException e) {
            throw new BrokerException("Exception occurred while handling authentication with Sasl", (Throwable)e);
        }
    }
}

