/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqFrameDecodingException;
import io.ballerina.messaging.broker.amqp.codec.auth.AuthenticationStrategy;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicAck;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicCancel;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicCancelOk;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicConsume;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicConsumeOk;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicDeliver;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicPublish;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicQos;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicQosOk;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicRecover;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicRecoveryOk;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicReject;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelClose;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelCloseOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelFlow;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelFlowOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelOpen;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelOpenOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionClose;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionCloseOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionOpen;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionOpenOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionSecure;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionSecureOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionStartOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionTuneOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxCommit;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxCommitOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxEnd;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxEndOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxForget;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxForgetOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxPrepare;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxPrepareOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxRecover;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxRecoverOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxRollback;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxRollbackOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxSelect;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxSetTimeout;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxSetTimeoutOk;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxStart;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxStartOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ExchangeDeclare;
import io.ballerina.messaging.broker.amqp.codec.frames.ExchangeDeclareOk;
import io.ballerina.messaging.broker.amqp.codec.frames.ExchangeDelete;
import io.ballerina.messaging.broker.amqp.codec.frames.ExchangeDeleteOk;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueBind;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueBindOk;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueDeclare;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueDeclareOk;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueDelete;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueDeleteOk;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueUnbind;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueUnbindOk;
import io.ballerina.messaging.broker.amqp.codec.frames.TxCommit;
import io.ballerina.messaging.broker.amqp.codec.frames.TxCommitOk;
import io.ballerina.messaging.broker.amqp.codec.frames.TxRollback;
import io.ballerina.messaging.broker.amqp.codec.frames.TxRollbackOk;
import io.ballerina.messaging.broker.amqp.codec.frames.TxSelect;
import io.ballerina.messaging.broker.amqp.codec.frames.TxSelectOk;

public class AmqMethodRegistry {
    public AmqMethodBodyFactory[][] factories = new AmqMethodBodyFactory[101][];

    public AmqMethodRegistry(AuthenticationStrategy authenticationStrategy) {
        this.factories[10] = new AmqMethodBodyFactory[52];
        this.factories[10][11] = ConnectionStartOk.getFactory(authenticationStrategy);
        this.factories[10][20] = ConnectionSecure.getFactory();
        this.factories[10][21] = ConnectionSecureOk.getFactory();
        this.factories[10][31] = ConnectionTuneOk.getFactory();
        this.factories[10][40] = ConnectionOpen.getFactory();
        this.factories[10][41] = ConnectionOpenOk.getFactory();
        this.factories[10][50] = ConnectionClose.getFactory();
        this.factories[10][51] = ConnectionCloseOk.getFactory();
        this.factories[20] = new AmqMethodBodyFactory[42];
        this.factories[20][10] = ChannelOpen.getFactory();
        this.factories[20][11] = ChannelOpenOk.getFactory();
        this.factories[20][20] = ChannelFlow.getFactory();
        this.factories[20][21] = ChannelFlowOk.getFactory();
        this.factories[20][40] = ChannelClose.getFactory();
        this.factories[20][41] = ChannelCloseOk.getFactory();
        this.factories[40] = new AmqMethodBodyFactory[24];
        this.factories[40][10] = ExchangeDeclare.getFactory();
        this.factories[40][11] = ExchangeDeclareOk.getFactory();
        this.factories[40][20] = ExchangeDelete.getFactory();
        this.factories[40][21] = ExchangeDeleteOk.getFactory();
        this.factories[50] = new AmqMethodBodyFactory[52];
        this.factories[50][10] = QueueDeclare.getFactory();
        this.factories[50][11] = QueueDeclareOk.getFactory();
        this.factories[50][20] = QueueBind.getFactory();
        this.factories[50][21] = QueueBindOk.getFactory();
        this.factories[50][40] = QueueDelete.getFactory();
        this.factories[50][41] = QueueDeleteOk.getFactory();
        this.factories[50][50] = QueueUnbind.getFactory();
        this.factories[50][51] = QueueUnbindOk.getFactory();
        this.factories[60] = new AmqMethodBodyFactory[112];
        this.factories[60][10] = BasicQos.getFactory();
        this.factories[60][11] = BasicQosOk.getFactory();
        this.factories[60][20] = BasicConsume.getFactory();
        this.factories[60][21] = BasicConsumeOk.getFactory();
        this.factories[60][30] = BasicCancel.getFactory();
        this.factories[60][31] = BasicCancelOk.getFactory();
        this.factories[60][40] = BasicPublish.getFactory();
        this.factories[60][60] = BasicDeliver.getFactory();
        this.factories[60][80] = BasicAck.getFactory();
        this.factories[60][90] = BasicReject.getFactory();
        this.factories[60][110] = BasicRecover.getFactory();
        this.factories[60][111] = BasicRecoveryOk.getFactory();
        this.factories[90] = new AmqMethodBodyFactory[32];
        this.factories[90][10] = TxSelect.getFactory();
        this.factories[90][11] = TxSelectOk.getFactory();
        this.factories[90][20] = TxCommit.getFactory();
        this.factories[90][21] = TxCommitOk.getFactory();
        this.factories[90][30] = TxRollback.getFactory();
        this.factories[90][31] = TxRollbackOk.getFactory();
        this.factories[100] = new AmqMethodBodyFactory[102];
        this.factories[100][10] = DtxSelect.getFactory();
        this.factories[100][20] = DtxStart.getFactory();
        this.factories[100][21] = DtxStartOk.getFactory();
        this.factories[100][30] = DtxEnd.getFactory();
        this.factories[100][31] = DtxEndOk.getFactory();
        this.factories[100][40] = DtxCommit.getFactory();
        this.factories[100][41] = DtxCommitOk.getFactory();
        this.factories[100][50] = DtxForget.getFactory();
        this.factories[100][51] = DtxForgetOk.getFactory();
        this.factories[100][70] = DtxPrepare.getFactory();
        this.factories[100][71] = DtxPrepareOk.getFactory();
        this.factories[100][80] = DtxRecover.getFactory();
        this.factories[100][81] = DtxRecoverOk.getFactory();
        this.factories[100][90] = DtxRollback.getFactory();
        this.factories[100][91] = DtxRollbackOk.getFactory();
        this.factories[100][100] = DtxSetTimeout.getFactory();
        this.factories[100][101] = DtxSetTimeoutOk.getFactory();
    }

    public AmqMethodBodyFactory getFactory(short classId, short methodId) throws AmqFrameDecodingException {
        try {
            AmqMethodBodyFactory factory = this.factories[classId][methodId];
            if (factory == null) {
                throw new AmqFrameDecodingException(503, "Method " + methodId + " unknown in AMQP version 0-91 (while trying to decode class " + classId + " method " + methodId + ".");
            }
            return factory;
        }
        catch (NullPointerException e) {
            throw new AmqFrameDecodingException(503, "Class " + classId + " unknown in AMQP version 0-91 (while trying to decode class " + classId + " method " + methodId + ".");
        }
        catch (IndexOutOfBoundsException e) {
            if (classId >= this.factories.length) {
                throw new AmqFrameDecodingException(503, "Class " + classId + " unknown in AMQP version 0-91 (while trying to decode class " + classId + " method " + methodId + ".");
            }
            throw new AmqFrameDecodingException(503, "Method " + methodId + " unknown in AMQP version 0-91 (while trying to decode class " + classId + " method " + methodId + ".");
        }
    }
}

