/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAck
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAck.class);
    private final long deliveryTag;
    private final boolean multiple;

    public BasicAck(int channel, long deliveryTag, boolean multiple) {
        super(channel, (short)60, (short)80);
        this.deliveryTag = deliveryTag;
        this.multiple = multiple;
    }

    @Override
    protected long getMethodBodySize() {
        return 9L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeLong(this.deliveryTag);
        buf.writeBoolean(this.multiple);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> channel.acknowledge(this.deliveryTag, this.multiple));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            long deliveryTag = buf.readLong();
            boolean multiple = buf.readBoolean();
            return new BasicAck(channel, deliveryTag, multiple);
        };
    }
}

