/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicConsumeOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class BasicCancelOk
extends MethodFrame {
    private final ShortString consumerTag;

    public BasicCancelOk(int channel, ShortString consumerTag) {
        super(channel, (short)60, (short)31);
        this.consumerTag = consumerTag;
    }

    @Override
    protected long getMethodBodySize() {
        return this.consumerTag.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.consumerTag.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            ShortString consumerTag = ShortString.parse((ByteBuf)buf);
            return new BasicConsumeOk(channel, consumerTag);
        };
    }
}

