/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.BasicQosOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicQos
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicQos.class);
    private final long prefetchWindowSize;
    private final int prefetchCount;
    private final boolean global;

    public BasicQos(int channel, long prefetchWindowSize, int prefetchCount, boolean global) {
        super(channel, (short)60, (short)10);
        this.prefetchWindowSize = prefetchWindowSize;
        this.prefetchCount = prefetchCount;
        this.global = global;
    }

    @Override
    protected long getMethodBodySize() {
        return 7L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeInt((int)this.prefetchWindowSize);
        buf.writeShort(this.prefetchCount);
        buf.writeBoolean(this.global);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        int channelId = this.getChannel();
        AmqpChannel channel = connectionHandler.getChannel(channelId);
        channel.setPrefetchCount(this.prefetchCount);
        ctx.writeAndFlush((Object)new BasicQosOk(channelId));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            long prefetchWindowSize = buf.readUnsignedInt();
            int prefetchCount = buf.readUnsignedShort();
            boolean global = buf.readBoolean();
            return new BasicQos(channel, prefetchWindowSize, prefetchCount, global);
        };
    }
}

