/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class BasicReject
extends MethodFrame {
    private final long deliveryTag;
    private final boolean requeue;

    public BasicReject(int channel, long deliveryTag, boolean requeue) {
        super(channel, (short)60, (short)90);
        this.deliveryTag = deliveryTag;
        this.requeue = requeue;
    }

    @Override
    protected long getMethodBodySize() {
        return 9L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeLong(this.deliveryTag);
        buf.writeBoolean(this.requeue);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> channel.reject(this.deliveryTag, this.requeue));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            long deliveryTag = buf.readLong();
            boolean requeue = buf.readBoolean();
            return new BasicReject(channel, deliveryTag, requeue);
        };
    }
}

