/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.AmqpDeliverMessage;
import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelFlowOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelFlow
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelFlow.class);
    private final boolean active;

    public ChannelFlow(int channel, boolean active) {
        super(channel, (short)20, (short)20);
        this.active = active;
    }

    @Override
    protected long getMethodBodySize() {
        return 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeBoolean(this.active);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        channel.setFlow(this.active);
        LOGGER.debug("Channel.flow method received. ChannelId: {} active: {} ", (Object)this.getChannel(), (Object)this.active);
        ctx.write((Object)new ChannelFlowOk(this.getChannel(), this.active));
        if (this.active) {
            for (AmqpDeliverMessage message : channel.getPendingMessages()) {
                ctx.channel().write((Object)message);
            }
        }
        ctx.flush();
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            boolean active = buf.readBoolean();
            return new ChannelFlow(channel, active);
        };
    }
}

