/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionOpenOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class ConnectionOpen
extends MethodFrame {
    private final ShortString virtualHost;

    public ConnectionOpen(ShortString virtualHost) {
        super(0, (short)10, (short)40);
        this.virtualHost = virtualHost;
    }

    @Override
    protected long getMethodBodySize() {
        return this.virtualHost.getSize() + 1L + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.virtualHost.write(buf);
        buf.writeByte(0);
        buf.writeByte(1);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        ctx.writeAndFlush((Object)new ConnectionOpenOk());
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            ShortString virtualHost = ShortString.parse((ByteBuf)buf);
            short stringSize = buf.readUnsignedByte();
            buf.skipBytes(stringSize + 1);
            return new ConnectionOpen(virtualHost);
        };
    }
}

