/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class ConnectionSecure
extends MethodFrame {
    private final LongString challenge;

    public ConnectionSecure(int channel, LongString challenge) {
        super(channel, (short)10, (short)20);
        this.challenge = challenge;
    }

    @Override
    protected long getMethodBodySize() {
        return this.challenge.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.challenge.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            LongString challenge = LongString.parse((ByteBuf)buf);
            return new ConnectionSecure(channel, challenge);
        };
    }
}

