/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class ConnectionStart
extends MethodFrame {
    public static final ConnectionStart DEFAULT_FRAME = new ConnectionStart(0, 0, 9, FieldTable.EMPTY_TABLE, LongString.parseString((String)"PLAIN"), LongString.parseString((String)"en_US"));
    private final byte majorVersion;
    private final byte minorVersion;
    private final FieldTable serverProperties;
    private final LongString mechanisms;
    private final LongString locales;

    public ConnectionStart(short channel, byte majorVersion, byte minorVersion, FieldTable serverProperties, LongString mechanisms, LongString locales) {
        super(channel, (short)10, (short)10);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.serverProperties = serverProperties;
        this.mechanisms = mechanisms;
        this.locales = locales;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.serverProperties.getSize() + this.mechanisms.getSize() + this.locales.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeByte((int)this.majorVersion);
        buf.writeByte((int)this.minorVersion);
        this.serverProperties.write(buf);
        this.mechanisms.write(buf);
        this.locales.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }
}

