/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.XaResult;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxCommitOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class DtxCommit
extends MethodFrame {
    private static final short CLASS_ID = 100;
    private static final short METHOD_ID = 40;
    private final int format;
    private final LongString globalId;
    private final LongString branchId;
    private final boolean onePhase;

    public DtxCommit(int channel, int format, LongString globalId, LongString branchId, boolean onePhase) {
        super(channel, (short)100, (short)40);
        this.format = format;
        this.globalId = globalId;
        this.branchId = branchId;
        this.onePhase = onePhase;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.globalId.getSize() + this.branchId.getSize() + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(this.format);
        this.globalId.write(buf);
        this.branchId.write(buf);
        int flag = 0;
        if (this.onePhase) {
            flag = (byte)(flag | 1);
        }
        buf.writeByte(flag);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        int channelId = this.getChannel();
        ctx.writeAndFlush((Object)new DtxCommitOk(channelId, XaResult.XA_OK.getValue()));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            int format = buf.readUnsignedShort();
            LongString globalId = LongString.parse((ByteBuf)buf);
            LongString branchId = LongString.parse((ByteBuf)buf);
            byte flag = buf.readByte();
            boolean onePhase = (flag & 1) == 1;
            return new DtxCommit(channel, format, globalId, branchId, onePhase);
        };
    }
}

