/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.XaResult;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxEndOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class DtxEnd
extends MethodFrame {
    private static final short CLASS_ID = 100;
    private static final short METHOD_ID = 30;
    private final int format;
    private final LongString globalId;
    private final LongString branchId;
    private final boolean fail;
    private final boolean suspend;

    public DtxEnd(int channel, int format, LongString globalId, LongString branchId, boolean fail, boolean suspend) {
        super(channel, (short)100, (short)30);
        this.format = format;
        this.globalId = globalId;
        this.branchId = branchId;
        this.fail = fail;
        this.suspend = suspend;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.globalId.getSize() + this.branchId.getSize() + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(this.format);
        this.globalId.write(buf);
        this.branchId.write(buf);
        byte flags = 0;
        if (this.fail) {
            flags = (byte)(flags | 1);
        }
        if (this.suspend) {
            flags = (byte)(flags | 2);
        }
        buf.writeByte((int)flags);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        int channelId = this.getChannel();
        ctx.writeAndFlush((Object)new DtxEndOk(channelId, XaResult.XA_OK.getValue()));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            int format = buf.readUnsignedShort();
            LongString globalId = LongString.parse((ByteBuf)buf);
            LongString branchId = LongString.parse((ByteBuf)buf);
            byte flags = buf.readByte();
            boolean fail = (flags & 1) == 1;
            boolean suspend = (flags & 2) == 2;
            return new DtxEnd(channel, format, globalId, branchId, fail, suspend);
        };
    }
}

