/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.XaResult;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.DtxPrepareOk;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.LongString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class DtxPrepare
extends MethodFrame {
    private static final short CLASS_ID = 100;
    private static final short METHOD_ID = 70;
    private final int format;
    private final LongString globalId;
    private final LongString branchId;

    public DtxPrepare(int channel, int format, LongString globalId, LongString branchId) {
        super(channel, (short)100, (short)70);
        this.format = format;
        this.globalId = globalId;
        this.branchId = branchId;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.globalId.getSize() + this.branchId.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(this.format);
        this.globalId.write(buf);
        this.branchId.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        int channelId = this.getChannel();
        ctx.writeAndFlush((Object)new DtxPrepareOk(channelId, XaResult.XA_OK.getValue()));
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            int format = buf.readUnsignedShort();
            LongString globalId = LongString.parse((ByteBuf)buf);
            LongString branchId = LongString.parse((ByteBuf)buf);
            return new DtxPrepare(channel, format, globalId, branchId);
        };
    }
}

