/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.InMemoryMessageAggregator;
import io.ballerina.messaging.broker.amqp.codec.frames.GeneralFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.EncodableData;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.common.data.types.LongInt;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.Metadata;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;

public class HeaderFrame
extends GeneralFrame {
    private static final int CONTENT_TYPE_MASK = 32768;
    private static final int ENCODING_MASK = 16384;
    private static final int HEADERS_MASK = 8192;
    private static final int DELIVERY_MODE_MASK = 4096;
    private static final int PRIORITY_MASK = 2048;
    private static final int CORRELATION_ID_MASK = 1024;
    private static final int REPLY_TO_MASK = 512;
    private static final int EXPIRATION_MASK = 256;
    private static final int MESSAGE_ID_MASK = 128;
    private static final int TIMESTAMP_MASK = 64;
    private static final int TYPE_MASK = 32;
    private static final int USER_ID_MASK = 16;
    private static final int APPLICATION_ID_MASK = 8;
    private static final int LAST_BIT_MASK = 1;
    private static final ShortString REPLY_TO = ShortString.parseString((String)"replyTo");
    private static final ShortString TIMESTAMP = ShortString.parseString((String)"timestamp");
    private static final ShortString TYPE = ShortString.parseString((String)"type");
    private static final ShortString USER_ID = ShortString.parseString((String)"userId");
    private static final ShortString APPLICATION_ID = ShortString.parseString((String)"applicationId");
    private static final ShortString PROPERTY_FLAGS = ShortString.parseString((String)"propertyFlags");
    private final long bodySize;
    private final int classId;
    private FieldTable headers;
    private FieldTable properties;

    public HeaderFrame(int channel, int classId, long bodySize) {
        super((byte)2, channel);
        this.classId = classId;
        this.bodySize = bodySize;
        this.properties = new FieldTable(new HashMap());
        this.headers = FieldTable.EMPTY_TABLE;
    }

    @Override
    public long getPayloadSize() {
        long propertyListSize = 0L;
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.CONTENT_TYPE));
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.CONTENT_ENCODING));
        propertyListSize += this.getPropertySize(this.headers);
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.DELIVERY_MODE));
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.PRIORITY));
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.CORRELATION_ID));
        propertyListSize += this.getPropertySize(this.properties.getValue(REPLY_TO));
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.EXPIRATION));
        propertyListSize += this.getPropertySize(this.properties.getValue(Metadata.MESSAGE_ID));
        propertyListSize += this.getPropertySize(this.properties.getValue(TIMESTAMP));
        propertyListSize += this.getPropertySize(this.properties.getValue(TYPE));
        propertyListSize += this.getPropertySize(this.properties.getValue(USER_ID));
        return 14L + (propertyListSize += this.getPropertySize(this.properties.getValue(APPLICATION_ID)));
    }

    private long getPropertySize(FieldValue fieldValue) {
        if (fieldValue != null) {
            return fieldValue.getValueSize();
        }
        return 0L;
    }

    private long getPropertySize(FieldTable fieldTable) {
        if (fieldTable != null) {
            return fieldTable.getSize();
        }
        return 0L;
    }

    @Override
    public void writePayload(ByteBuf buf) {
        buf.writeShort(this.classId);
        buf.writeShort(0);
        buf.writeLong(this.bodySize);
        int propertyFlags = this.getPropertyFlagsValue(this.properties.getValue(PROPERTY_FLAGS));
        buf.writeShort(propertyFlags);
        this.writeProperty(buf, this.properties.getValue(Metadata.CONTENT_TYPE));
        this.writeProperty(buf, this.properties.getValue(Metadata.CONTENT_ENCODING));
        this.writeFieldTable(buf, this.headers);
        this.writeProperty(buf, this.properties.getValue(Metadata.DELIVERY_MODE));
        this.writeProperty(buf, this.properties.getValue(Metadata.PRIORITY));
        this.writeProperty(buf, this.properties.getValue(Metadata.CORRELATION_ID));
        this.writeProperty(buf, this.properties.getValue(REPLY_TO));
        this.writeProperty(buf, this.properties.getValue(Metadata.EXPIRATION));
        this.writeProperty(buf, this.properties.getValue(Metadata.MESSAGE_ID));
        this.writeProperty(buf, this.properties.getValue(TIMESTAMP));
        this.writeProperty(buf, this.properties.getValue(TYPE));
        this.writeProperty(buf, this.properties.getValue(USER_ID));
        this.writeProperty(buf, this.properties.getValue(APPLICATION_ID));
    }

    private int getPropertyFlagsValue(FieldValue value) {
        if (value == null) {
            return this.updatePropertyFlags();
        }
        return ((LongInt)value.getValue()).getInt();
    }

    private int updatePropertyFlags() {
        int flags = 0;
        if (this.properties.getValue(Metadata.CONTENT_TYPE) != null) {
            flags |= 0x8000;
        }
        if (this.properties.getValue(Metadata.CONTENT_ENCODING) != null) {
            flags |= 0x4000;
        }
        if (this.headers != null) {
            flags |= 0x2000;
        }
        if (this.properties.getValue(Metadata.DELIVERY_MODE) != null) {
            flags |= 0x1000;
        }
        if (this.properties.getValue(Metadata.PRIORITY) != null) {
            flags |= 0x800;
        }
        if (this.properties.getValue(Metadata.CORRELATION_ID) != null) {
            flags |= 0x400;
        }
        if (this.properties.getValue(REPLY_TO) != null) {
            flags |= 0x200;
        }
        if (this.properties.getValue(Metadata.EXPIRATION) != null) {
            flags |= 0x100;
        }
        if (this.properties.getValue(Metadata.MESSAGE_ID) != null) {
            flags |= 0x80;
        }
        if (this.properties.getValue(TIMESTAMP) != null) {
            flags |= 0x40;
        }
        if (this.properties.getValue(TYPE) != null) {
            flags |= 0x20;
        }
        if (this.properties.getValue(USER_ID) != null) {
            flags |= 0x10;
        }
        if (this.properties.getValue(APPLICATION_ID) != null) {
            flags |= 8;
        }
        return flags;
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        InMemoryMessageAggregator inMemoryMessageAggregator = channel.getMessageAggregator();
        inMemoryMessageAggregator.headerFrameReceived(this.headers, this.properties, this.bodySize);
    }

    private void writeProperty(ByteBuf buf, FieldValue fieldValue) {
        EncodableData data;
        if (fieldValue != null && (data = fieldValue.getValue()) != null) {
            data.write(buf);
        }
    }

    private void writeFieldTable(ByteBuf buf, FieldTable fieldTable) {
        if (fieldTable != null) {
            fieldTable.write(buf);
        }
    }

    public static HeaderFrame parse(ByteBuf buf, int channel) throws Exception {
        boolean hasMoreProperties;
        int classId = buf.readUnsignedShort();
        buf.skipBytes(2);
        long bodySize = buf.readLong();
        HeaderFrame headerFrame = new HeaderFrame(channel, classId, bodySize);
        int propertyFlags = buf.readUnsignedShort();
        boolean bl = hasMoreProperties = (propertyFlags & 1) != 0;
        while (hasMoreProperties) {
            int otherPropertyFlags = buf.readUnsignedShort();
            hasMoreProperties = (otherPropertyFlags & 1) != 0;
        }
        if ((propertyFlags & 0x8000) != 0) {
            headerFrame.setContentType(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x4000) != 0) {
            headerFrame.setContentEncoding(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x2000) != 0) {
            headerFrame.setHeaders(FieldTable.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x1000) != 0) {
            headerFrame.setDeliveryMode(buf.readUnsignedByte());
        }
        if ((propertyFlags & 0x800) != 0) {
            headerFrame.setPriority(buf.readUnsignedByte());
        }
        if ((propertyFlags & 0x400) != 0) {
            headerFrame.setCorrelationId(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x200) != 0) {
            headerFrame.setReplyTo(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x100) != 0) {
            headerFrame.setExpiration(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x80) != 0) {
            headerFrame.setMessageId(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x40) != 0) {
            headerFrame.setTimestamp(buf.readLong());
        }
        if ((propertyFlags & 0x20) != 0) {
            headerFrame.setType(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 0x10) != 0) {
            headerFrame.setUserId(ShortString.parse((ByteBuf)buf));
        }
        if ((propertyFlags & 8) != 0) {
            headerFrame.setAppId(ShortString.parse((ByteBuf)buf));
        }
        headerFrame.properties.add(PROPERTY_FLAGS, FieldValue.parseLongInt((int)propertyFlags));
        return headerFrame;
    }

    public void setContentType(ShortString contentType) {
        this.properties.add(Metadata.CONTENT_TYPE, FieldValue.parseShortString((ShortString)contentType));
    }

    public void setContentEncoding(ShortString contentEncoding) {
        this.properties.add(Metadata.CONTENT_ENCODING, FieldValue.parseShortString((ShortString)contentEncoding));
    }

    public void setHeaders(FieldTable headers) {
        this.headers = headers;
    }

    public void setDeliveryMode(short deliveryMode) {
        this.properties.add(Metadata.DELIVERY_MODE, FieldValue.parseShortShortInt((byte)((byte)deliveryMode)));
    }

    public void setPriority(short priority) {
        this.properties.add(Metadata.PRIORITY, FieldValue.parseShortShortInt((byte)((byte)priority)));
    }

    public void setCorrelationId(ShortString correlationId) {
        this.properties.add(Metadata.CORRELATION_ID, FieldValue.parseShortString((ShortString)correlationId));
    }

    public void setReplyTo(ShortString replyTo) {
        this.properties.add(REPLY_TO, FieldValue.parseShortString((ShortString)replyTo));
    }

    public void setExpiration(ShortString expiration) {
        this.properties.add(Metadata.EXPIRATION, FieldValue.parseShortString((ShortString)expiration));
    }

    public void setMessageId(ShortString messageId) {
        this.properties.add(Metadata.MESSAGE_ID, FieldValue.parseShortString((ShortString)messageId));
    }

    public void setTimestamp(long timestamp) {
        this.properties.add(TIMESTAMP, FieldValue.parseLongLongInt((long)timestamp));
    }

    public void setType(ShortString type) {
        this.properties.add(TYPE, FieldValue.parseShortString((ShortString)type));
    }

    public void setUserId(ShortString userId) {
        this.properties.add(USER_ID, FieldValue.parseShortString((ShortString)userId));
    }

    public void setAppId(ShortString appId) {
        this.properties.add(APPLICATION_ID, FieldValue.parseShortString((ShortString)appId));
    }

    public void setProperties(FieldTable properties) {
        this.properties = properties;
    }
}

