/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueDeclareOk
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueDeclareOk.class);
    private final ShortString queue;
    private final long messageCount;
    private final long consumerCount;

    public QueueDeclareOk(int channel, ShortString queue, long messageCount, long consumerCount) {
        super(channel, (short)50, (short)11);
        this.queue = queue;
        this.messageCount = messageCount;
        this.consumerCount = consumerCount;
    }

    @Override
    protected long getMethodBodySize() {
        return this.queue.getSize() + 4L + 4L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        this.queue.write(buf);
        buf.writeInt((int)this.messageCount);
        buf.writeInt((int)this.consumerCount);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            ShortString queue = ShortString.parse((ByteBuf)buf);
            long messageCount = buf.readUnsignedInt();
            long consumerCount = buf.readUnsignedInt();
            return new QueueDeclareOk(channel, queue, messageCount, consumerCount);
        };
    }
}

