/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelClose;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionClose;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueDeleteOk;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueDelete
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueDelete.class);
    private static final short CLASS_ID = 50;
    private static final short METHOD_ID = 40;
    private final ShortString queue;
    private final boolean ifUnused;
    private final boolean ifEmpty;
    private final boolean noWait;

    QueueDelete(int channel, ShortString queue, boolean ifUnused, boolean ifEmpty, boolean noWait) {
        super(channel, (short)50, (short)40);
        this.queue = queue;
        this.ifUnused = ifUnused;
        this.ifEmpty = ifEmpty;
        this.noWait = noWait;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.queue.getSize() + 1L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.queue.write(buf);
        int flags = 0;
        if (this.ifUnused) {
            flags |= 1;
        }
        if (this.ifEmpty) {
            flags |= 2;
        }
        if (this.noWait) {
            flags |= 4;
        }
        buf.writeByte(flags);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        Broker broker = connectionHandler.getBroker();
        ctx.fireChannelRead(() -> {
            try {
                int messageCount = broker.deleteQueue(this.queue.toString(), this.ifUnused, this.ifEmpty);
                ctx.writeAndFlush((Object)new QueueDeleteOk(this.getChannel(), (long)messageCount));
            }
            catch (ResourceNotFoundException e) {
                ctx.writeAndFlush((Object)new QueueDeleteOk(this.getChannel(), 0L));
            }
            catch (ValidationException e) {
                LOGGER.debug("Queue delete validation failure", (Throwable)e);
                ctx.writeAndFlush((Object)new ChannelClose(this.getChannel(), 406, ShortString.parseString((String)e.getMessage()), 50, 40));
            }
            catch (BrokerException e) {
                LOGGER.warn("Error deleting queue.", (Throwable)e);
                ctx.writeAndFlush((Object)new ConnectionClose(541, ShortString.parseString((String)e.getMessage()), 50, 40));
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString queue = ShortString.parse((ByteBuf)buf);
            long flags = buf.readByte();
            boolean ifUnused = (flags & 1L) == 1L;
            boolean ifEmpty = (flags & 2L) == 2L;
            boolean noWait = (flags & 4L) == 4L;
            return new QueueDelete(channel, queue, ifUnused, ifEmpty, noWait);
        };
    }
}

