/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionClose;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.frames.QueueUnbindOk;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.BrokerException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class QueueUnbind
extends MethodFrame {
    private static final short CLASS_ID = 50;
    private static final short METHOD_ID = 50;
    private final ShortString queue;
    private final ShortString exchange;
    private final ShortString routingKey;
    private final FieldTable arguments;

    public QueueUnbind(int channel, ShortString queue, ShortString exchange, ShortString routingKey, FieldTable arguments) {
        super(channel, (short)50, (short)50);
        this.queue = queue;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.arguments = arguments;
    }

    @Override
    protected long getMethodBodySize() {
        return 2L + this.queue.getSize() + this.exchange.getSize() + this.routingKey.getSize() + this.arguments.getSize();
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
        buf.writeShort(0);
        this.queue.write(buf);
        this.exchange.write(buf);
        this.routingKey.write(buf);
        this.arguments.write(buf);
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        AmqpChannel channel = connectionHandler.getChannel(this.getChannel());
        ctx.fireChannelRead(() -> {
            try {
                channel.unbind(this.queue, this.exchange, this.routingKey);
                ctx.writeAndFlush((Object)new QueueUnbindOk(channel.getChannelId()));
            }
            catch (BrokerException e) {
                ctx.writeAndFlush((Object)new ConnectionClose(541, ShortString.parseString((String)e.getMessage()), 50, 50));
            }
            catch (ValidationException e) {
                ctx.writeAndFlush((Object)new ConnectionClose(530, ShortString.parseString((String)e.getMessage()), 50, 50));
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> {
            buf.skipBytes(2);
            ShortString queue = ShortString.parse((ByteBuf)buf);
            ShortString exchange = ShortString.parse((ByteBuf)buf);
            ShortString routingKey = ShortString.parse((ByteBuf)buf);
            FieldTable arguments = FieldTable.parse((ByteBuf)buf);
            return new QueueUnbind(channel, queue, exchange, routingKey, arguments);
        };
    }
}

