/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelClose;
import io.ballerina.messaging.broker.amqp.codec.frames.ConnectionClose;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.frames.TxCommitOk;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.ballerina.messaging.broker.core.BrokerException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxCommit
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxCommit.class);
    private static final short CLASS_ID = 90;
    private static final short METHOD_ID = 20;

    public TxCommit(int channel) {
        super(channel, (short)90, (short)20);
    }

    @Override
    protected long getMethodBodySize() {
        return 0L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        int channelId = this.getChannel();
        AmqpChannel channel = connectionHandler.getChannel(channelId);
        ctx.fireChannelRead(() -> {
            try {
                channel.commit();
                ctx.writeAndFlush((Object)new TxCommitOk(channelId));
            }
            catch (ValidationException e) {
                LOGGER.warn("User input error while commit transaction", (Throwable)e);
                ctx.writeAndFlush((Object)new ChannelClose(channelId, 406, ShortString.parseString((String)e.getMessage()), 90, 20));
            }
            catch (BrokerException e) {
                LOGGER.error("Error occurred while committing transaction", (Throwable)e);
                ctx.writeAndFlush((Object)new ConnectionClose(541, ShortString.parseString((String)e.getMessage()), 90, 20));
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> new TxCommit(channel);
    }
}

