/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.amqp.codec.frames;

import io.ballerina.messaging.broker.amqp.codec.AmqpChannel;
import io.ballerina.messaging.broker.amqp.codec.frames.AmqMethodBodyFactory;
import io.ballerina.messaging.broker.amqp.codec.frames.ChannelClose;
import io.ballerina.messaging.broker.amqp.codec.frames.MethodFrame;
import io.ballerina.messaging.broker.amqp.codec.frames.TxRollbackOk;
import io.ballerina.messaging.broker.amqp.codec.handlers.AmqpConnectionHandler;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxRollback
extends MethodFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxRollback.class);
    private static final short CLASS_ID = 90;
    private static final short METHOD_ID = 30;

    public TxRollback(int channel) {
        super(channel, (short)90, (short)30);
    }

    @Override
    protected long getMethodBodySize() {
        return 0L;
    }

    @Override
    protected void writeMethod(ByteBuf buf) {
    }

    @Override
    public void handle(ChannelHandlerContext ctx, AmqpConnectionHandler connectionHandler) {
        int channelId = this.getChannel();
        AmqpChannel channel = connectionHandler.getChannel(channelId);
        ctx.fireChannelRead(() -> {
            try {
                channel.rollback();
                ctx.writeAndFlush((Object)new TxRollbackOk(channelId));
            }
            catch (ValidationException e) {
                LOGGER.error("Error while rollback transaction", (Throwable)e);
                ctx.writeAndFlush((Object)new ChannelClose(channelId, 406, ShortString.parseString((String)e.getMessage()), 90, 30));
            }
        });
    }

    public static AmqMethodBodyFactory getFactory() {
        return (buf, channel, size) -> new TxRollback(channel);
    }
}

