/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback.policy;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.logback.policy.FileNamePatternValidator;
import io.bootique.logback.policy.RollingPolicyFactory;

@JsonTypeName(value="fixedWindow")
@BQConfig
public class FixedWindowPolicyFactory
extends RollingPolicyFactory {
    private String fileSize;

    @BQConfigProperty
    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    protected FixedWindowRollingPolicy instantiatePolicy(LoggerContext context) {
        FixedWindowRollingPolicy policy = new FixedWindowRollingPolicy();
        policy.setFileNamePattern(this.getFileNamePattern());
        if (this.getHistorySize() > 0) {
            policy.setMinIndex(1);
            policy.setMaxIndex(this.getHistorySize());
        }
        policy.setContext((Context)context);
        return policy;
    }

    @Override
    public TriggeringPolicy<ILoggingEvent> createTriggeringPolicy(LoggerContext context) {
        SizeBasedTriggeringPolicy policy = new SizeBasedTriggeringPolicy();
        if (this.fileSize != null && this.fileSize.length() > 0) {
            policy.setMaxFileSize(FileSize.valueOf((String)this.fileSize));
        }
        policy.setContext((Context)context);
        return policy;
    }

    @Override
    protected FileNamePatternValidator getFileNamePatternValidator(LoggerContext context) {
        return new FileNamePatternValidator(context, this.getFileNamePattern(), FixedWindowRollingPolicy.class.getSimpleName()){

            @Override
            protected void validate() {
                this.checkPattern(false, true);
            }
        };
    }
}

