/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.constants;

public interface PluginParamConstants {
    public String getValue();

    public static enum LDAP implements PluginParamConstants
    {
        URL("ldap.url"),
        DN("ldap.dn"),
        PASSWORD("ldap.password"),
        OU("ldap.ou"),
        FILTER("ldap.filter"),
        MAPPING("ldap.mapping"),
        OPEN("ldap.open");

        private String value;

        private LDAP(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum BASE implements PluginParamConstants
    {
        URL("base.url"),
        CONCURRENCY("base.concurrency"),
        PROMETHEUS_HOST("base.prometheus.host");

        private String value;

        private BASE(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum MAIL implements PluginParamConstants
    {
        SERVER("smtp.host"),
        PORT("smtp.port"),
        ACCOUNT("smtp.account"),
        PASSWORD("smtp.password"),
        SSL("smtp.ssl"),
        TLS("smtp.tls"),
        RECIPIENTS("smtp.recipient");

        private String value;

        private MAIL(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum I18n implements PluginParamConstants
    {
        LANGUAGE("i18n.language");

        private String value;

        private I18n(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum Registry implements PluginParamConstants
    {
        URL("registry.url"),
        REPO("registry.repo"),
        USERNAME("registry.username"),
        PASSWORD("registry.password");

        private String value;

        private Registry(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    public static enum Classify implements PluginParamConstants
    {
        MAIL("smtp"),
        BASE("base"),
        LDAP("ldap"),
        REGISTRY("registry");

        private String value;

        private Classify(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum Type implements PluginParamConstants
    {
        PASSWORD("password"),
        TEXT("text"),
        JSON("json");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

