/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import cn.hutool.core.util.ReflectUtil;
import io.dataease.plugins.common.constants.SQLConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.ResolverUtil;

public class ConstantsUtil {
    public static final String TYPE_KEY_FIELD = "NAME";
    private static final String constsPackageName = "io.dataease.plugins.common.constants";
    private static final List<Class> SQLConstantsCache = new ArrayList<Class>();

    public static List<Class> getAllSQLConstants() {
        if (CollectionUtils.isEmpty(SQLConstantsCache)) {
            Set<Class<? extends Class<?>>> classes = ConstantsUtil.scanConstans(constsPackageName, SQLConstants.class);
            SQLConstantsCache.addAll(classes);
        }
        return SQLConstantsCache;
    }

    public static String constantsValue(String dsType, String constantKey) {
        List<Class> allSQLConstantsClass = ConstantsUtil.getAllSQLConstants();
        for (int i = 0; i < allSQLConstantsClass.size(); ++i) {
            Class classz = allSQLConstantsClass.get(i);
            Object fieldValue = ReflectUtil.getFieldValue((Object)classz, (String)TYPE_KEY_FIELD);
            if (!ObjectUtils.isNotEmpty((Object)fieldValue) || !StringUtils.equals((CharSequence)dsType, (CharSequence)fieldValue.toString())) continue;
            Object result = ReflectUtil.getFieldValue((Object)classz, (String)constantKey);
            return ObjectUtils.isNotEmpty((Object)result) ? result.toString() : null;
        }
        return null;
    }

    private static Set<Class<? extends Class<?>>> scanConstans(String packageName, Class<?> superType) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(superType), packageName);
        Set classesSet = resolverUtil.getClasses();
        return classesSet;
    }
}

