/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.request.datasource;

import com.alibaba.druid.util.StringUtils;
import io.dataease.plugins.common.base.domain.DatasetTableField;
import io.dataease.plugins.common.base.domain.Datasource;
import io.dataease.plugins.common.dto.chart.ChartViewFieldDTO;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatasourceRequest {
    private final String REG_WITH_SQL_FRAGMENT = "((?i)WITH[\\s\\S]+(?i)AS?\\s*\\([\\s\\S]+\\))\\s*(?i)SELECT";
    private Pattern WITH_SQL_FRAGMENT = Pattern.compile("((?i)WITH[\\s\\S]+(?i)AS?\\s*\\([\\s\\S]+\\))\\s*(?i)SELECT");
    protected String query;
    protected String table;
    protected Datasource datasource;
    private Integer pageSize;
    private Integer page;
    private Integer realSize;
    private Integer fetchSize = 10000;
    private boolean pageable = false;
    private boolean previewData = false;
    private List<ChartViewFieldDTO> xAxis;
    private List<ChartViewFieldDTO> yAxis;
    private List<DatasetTableField> permissionFields;
    private boolean totalPageFlag;

    public String getQuery() {
        return this.rebuildSqlWithFragment(this.query);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    private String rebuildSqlWithFragment(String sql) {
        String withFragment;
        Matcher matcher;
        if (!((String)sql).toLowerCase().startsWith("with") && (matcher = this.WITH_SQL_FRAGMENT.matcher((CharSequence)sql)).find() && !StringUtils.isEmpty((CharSequence)(withFragment = matcher.group()))) {
            if (withFragment.length() > 6) {
                int lastSelectIndex = withFragment.length() - 6;
                sql = ((String)sql).replace(withFragment, withFragment.substring(lastSelectIndex));
                withFragment = withFragment.substring(0, lastSelectIndex);
            }
            sql = withFragment + " " + (String)sql;
            sql = ((String)sql).replaceAll(" {2,}", " ");
        }
        return sql;
    }

    public String getREG_WITH_SQL_FRAGMENT() {
        return this.REG_WITH_SQL_FRAGMENT;
    }

    public Pattern getWITH_SQL_FRAGMENT() {
        return this.WITH_SQL_FRAGMENT;
    }

    public String getTable() {
        return this.table;
    }

    public Datasource getDatasource() {
        return this.datasource;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getRealSize() {
        return this.realSize;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public boolean isPreviewData() {
        return this.previewData;
    }

    public List<ChartViewFieldDTO> getXAxis() {
        return this.xAxis;
    }

    public List<ChartViewFieldDTO> getYAxis() {
        return this.yAxis;
    }

    public List<DatasetTableField> getPermissionFields() {
        return this.permissionFields;
    }

    public boolean isTotalPageFlag() {
        return this.totalPageFlag;
    }

    public void setWITH_SQL_FRAGMENT(Pattern WITH_SQL_FRAGMENT) {
        this.WITH_SQL_FRAGMENT = WITH_SQL_FRAGMENT;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setDatasource(Datasource datasource) {
        this.datasource = datasource;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setRealSize(Integer realSize) {
        this.realSize = realSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPageable(boolean pageable) {
        this.pageable = pageable;
    }

    public void setPreviewData(boolean previewData) {
        this.previewData = previewData;
    }

    public void setXAxis(List<ChartViewFieldDTO> xAxis) {
        this.xAxis = xAxis;
    }

    public void setYAxis(List<ChartViewFieldDTO> yAxis) {
        this.yAxis = yAxis;
    }

    public void setPermissionFields(List<DatasetTableField> permissionFields) {
        this.permissionFields = permissionFields;
    }

    public void setTotalPageFlag(boolean totalPageFlag) {
        this.totalPageFlag = totalPageFlag;
    }
}

