/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import io.dataease.plugins.common.util.ModuleClassLoader;
import io.dataease.plugins.common.util.SpringContextUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassloaderResponsity {
    private static Logger logger = LoggerFactory.getLogger(ClassloaderResponsity.class);
    private Map<String, ModuleClassLoader> responsityMap = new ConcurrentHashMap<String, ModuleClassLoader>();

    private ClassloaderResponsity() {
    }

    public void addClassLoader(String moduleName, ModuleClassLoader moduleClassLoader) {
        this.responsityMap.put(moduleName, moduleClassLoader);
    }

    public boolean containsClassLoader(String key) {
        return this.responsityMap.containsKey(key);
    }

    public ModuleClassLoader getClassLoader(String key) {
        return this.responsityMap.get(key);
    }

    public Collection<ModuleClassLoader> getAllClassLoader() {
        return this.responsityMap.values();
    }

    public void removeClassLoader(String moduleName) {
        ModuleClassLoader moduleClassLoader = this.responsityMap.get(moduleName);
        try {
            List<String> registeredBean = moduleClassLoader.getRegisteredBean();
            for (String beanName : registeredBean) {
                logger.info("\u5220\u9664bean:" + beanName);
                SpringContextUtil.getBeanFactory().removeBeanDefinition(beanName);
            }
            moduleClassLoader.close();
            this.responsityMap.remove(moduleName);
        }
        catch (IOException e) {
            logger.error("\u5220\u9664" + moduleName + "\u6a21\u5757\u53d1\u751f\u9519\u8bef");
        }
    }

    public static ClassloaderResponsity getInstance() {
        return ClassloaderResponsityHodler.instamce;
    }

    private static class ClassloaderResponsityHodler {
        private static ClassloaderResponsity instamce = new ClassloaderResponsity();

        private ClassloaderResponsityHodler() {
        }
    }
}

